/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.view.tableview;

import com.quantum.QuantumPlugin;
import com.quantum.sql.SQLResultSetCollection;
import com.quantum.sql.SQLResultSetResults;
import com.quantum.view.tableview.ResultSetViewer;
import com.quantum.view.tableview.TableViewActionGroup;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.ISelectionProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.TabFolder;
import org.eclipse.swt.widgets.TabItem;
import org.eclipse.ui.IActionBars;
import org.eclipse.ui.part.ViewPart;

public class TableView
extends ViewPart
implements ISelectionProvider,
PropertyChangeListener {
    public static final String NUMBER_OF_ROWS_PREFERENCE_NAME;
    protected TabFolder tabs = null;
    private Set listeners = Collections.synchronizedSet(new HashSet());
    protected List resultSetViewers = Collections.synchronizedList(new ArrayList());
    protected TableViewActionGroup actionGroup;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.quantum.view.tableview.TableView");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        NUMBER_OF_ROWS_PREFERENCE_NAME = String.valueOf(clazz.getName()) + ".numberOfRows";
    }

    public TableView() {
        SQLResultSetCollection.getInstance().addPropertyChangeListener(this);
    }

    public void setFocus() {
    }

    public void dispose() {
        SQLResultSetCollection.getInstance().removePropertyChangeListener(this);
        super.dispose();
    }

    public static TableView getInstance() {
        return (TableView)QuantumPlugin.getDefault().getView("com.quantum.view.tableview.TableView");
    }

    public void createPartControl(Composite parent) {
        this.tabs = new TabFolder(parent, 0);
        this.tabs.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                TableView.this.fireSelectionChangedEvent();
            }
        });
        SQLResultSetResults[] resultSets = SQLResultSetCollection.getInstance().getResultSets();
        int i = 0;
        int length = resultSets == null ? 0 : resultSets.length;
        while (i < length) {
            this.resultSetViewers.add(new ResultSetViewer(this, resultSets[i]));
            ++i;
        }
        this.initActions();
    }

    public void initActions() {
        this.actionGroup = new TableViewActionGroup(this);
        IActionBars actionBars = this.getViewSite().getActionBars();
        this.actionGroup.fillActionBars(actionBars);
    }

    public void addSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.add(listener);
    }

    protected void fireSelectionChangedEvent() {
        ISelection selection = this.getSelection();
        Iterator i = this.listeners.iterator();
        while (i.hasNext()) {
            ISelectionChangedListener listener = (ISelectionChangedListener)i.next();
            listener.selectionChanged(new SelectionChangedEvent((ISelectionProvider)this, selection));
        }
        ResultSetViewer results = this.getSelectedResultSetViewer();
        if (results != null) {
            results.updateStatusLine();
        } else {
            this.getViewSite().getActionBars().getStatusLineManager().setMessage("");
        }
    }

    public ISelection getSelection() {
        SQLResultSetResults selection = this.getSelectedResultSet();
        return selection == null ? new StructuredSelection() : new StructuredSelection((Object)selection);
    }

    public SQLResultSetResults getSelectedResultSet() {
        ResultSetViewer viewer = this.getSelectedResultSetViewer();
        return viewer == null ? null : viewer.getResultSet();
    }

    protected ResultSetViewer getSelectedResultSetViewer() {
        ResultSetViewer selection = null;
        int index = this.tabs.getSelectionIndex();
        if (index >= 0) {
            TabItem item = this.tabs.getItem(index);
            Iterator i = this.resultSetViewers.iterator();
            while (selection == null && i.hasNext()) {
                ResultSetViewer viewer = (ResultSetViewer)i.next();
                if (item != viewer.getTabItem()) continue;
                selection = viewer;
            }
        }
        return selection;
    }

    public void removeSelectionChangedListener(ISelectionChangedListener listener) {
        this.listeners.remove(listener);
    }

    public void setSelection(ISelection selection) {
    }

    public void propertyChange(PropertyChangeEvent event) {
        if ("resultSets".equals(event.getPropertyName())) {
            SQLResultSetResults selection = this.getSelectedResultSet();
            Collection additions = this.getAddedResultSets();
            Iterator i = additions.iterator();
            while (i.hasNext()) {
                SQLResultSetResults results = (SQLResultSetResults)i.next();
                this.resultSetViewers.add(new ResultSetViewer(this, results));
            }
            Collection deletions = this.getRemovedResultSets();
            Iterator i2 = deletions.iterator();
            while (i2.hasNext()) {
                SQLResultSetResults results = (SQLResultSetResults)i2.next();
                ResultSetViewer viewer = this.findViewerFor(results);
                this.resultSetViewers.remove(viewer);
                viewer.dispose();
            }
            SQLResultSetResults newSelection = this.getSelectedResultSet();
            if (selection != null && newSelection == null) {
                this.fireSelectionChangedEvent();
            } else if (selection == null && newSelection != null) {
                this.fireSelectionChangedEvent();
            } else if (selection != null && !selection.equals(newSelection)) {
                this.fireSelectionChangedEvent();
            }
        }
    }

    private Collection getRemovedResultSets() {
        SQLResultSetResults[] results = SQLResultSetCollection.getInstance().getResultSets();
        ArrayList collection = results == null ? new ArrayList() : new ArrayList<SQLResultSetResults>(Arrays.asList(results));
        Collection visible = this.getResultSets();
        visible.removeAll(collection);
        return visible;
    }

    private Collection getAddedResultSets() {
        SQLResultSetResults[] results = SQLResultSetCollection.getInstance().getResultSets();
        ArrayList collection = results == null ? new ArrayList() : new ArrayList<SQLResultSetResults>(Arrays.asList(results));
        collection.removeAll(this.getResultSets());
        return collection;
    }

    private Collection getResultSets() {
        ArrayList<SQLResultSetResults> list = new ArrayList<SQLResultSetResults>();
        Iterator i = this.resultSetViewers.iterator();
        while (i.hasNext()) {
            ResultSetViewer viewer = (ResultSetViewer)i.next();
            list.add(viewer.getResultSet());
        }
        return list;
    }

    public ResultSetViewer findViewerFor(SQLResultSetResults results) {
        ResultSetViewer viewer = null;
        Iterator i = this.resultSetViewers.iterator();
        while (viewer == null && i.hasNext()) {
            ResultSetViewer temp = (ResultSetViewer)i.next();
            if (results == null || !results.equals(temp.getResultSet())) continue;
            viewer = temp;
        }
        return viewer;
    }

    public TabFolder getTabFolder() {
        return this.tabs;
    }
}

