/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.view.subset;

import com.quantum.Messages;
import com.quantum.util.xml.XMLUtil;
import com.quantum.view.bookmark.TreeNode;
import com.quantum.view.subset.ObjectNode;
import com.quantum.view.subset.SubsetRoot;
import java.util.Collections;
import java.util.Vector;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SubsetNode
extends TreeNode {
    private String name = null;
    private Vector children = new Vector();

    public SubsetNode(SubsetNode param) {
        super(param.getParent());
        this.name = param.name;
        this.children.addAll(param.children);
    }

    public SubsetNode() {
        super(SubsetRoot.ROOT);
    }

    public SubsetNode(String name) {
        super(SubsetRoot.ROOT);
        this.name = name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public Object[] getChildren() {
        return this.children.toArray();
    }

    public boolean hasChildren() {
        return this.children != null && this.children.size() > 0;
    }

    public void setChildren(Vector children) {
        int i = 0;
        while (i < children.size()) {
            Object obj = children.elementAt(i);
            this.isValid(obj);
            ++i;
        }
        Collections.sort(children);
        this.children = children;
    }

    public void isValid(Object child) {
        boolean valid = false;
        if (child instanceof ObjectNode) {
            valid = true;
        }
        if (!valid) {
            throw new RuntimeException("Invalid SubsetNode child: " + child.getClass().getName());
        }
    }

    public TreeNode find(String name) {
        int i = 0;
        while (i < this.children.size()) {
            TreeNode node;
            Object obj = this.children.elementAt(i);
            if (obj instanceof TreeNode && name.equals((node = (TreeNode)obj).getName())) {
                return node;
            }
            ++i;
        }
        return null;
    }

    public boolean add(ObjectNode object) {
        if (this.children.indexOf(object) >= 0) {
            return false;
        }
        this.children.add(object);
        return true;
    }

    public boolean addReplace(ObjectNode object) {
        this.children.remove(object);
        return this.add(object);
    }

    public boolean remove(ObjectNode object) {
        return this.children.remove(object);
    }

    public void exportXML(Element root) {
        Element sub = XMLUtil.createElementText(root, Messages.getString("ExportXMLAction.Subset"), "");
        XMLUtil.createElementText(sub, Messages.getString("ExportXMLAction.SubsetName"), this.getName());
        int i = 0;
        while (i < this.children.size()) {
            Object obj = this.children.elementAt(i);
            boolean cfr_ignored_0 = obj instanceof ObjectNode;
            ++i;
        }
    }

    public void importXML(Element root, boolean replace) {
        if (replace) {
            String name = XMLUtil.getElementText(root, Messages.getString("ExportXMLAction.SubsetName"));
            if (name == "") {
                return;
            }
            this.setName(name);
        }
        this.importElementXML(root, replace, "table");
        this.importElementXML(root, replace, "view");
    }

    private void importElementXML(Element root, boolean replace, String type) {
        NodeList tables = root.getElementsByTagName(type);
        int i = 0;
        while (i < tables.getLength()) {
            Element cfr_ignored_0 = (Element)tables.item(i);
            ++i;
        }
    }

    protected String getImageName() {
        return "subset.gif";
    }

    protected void initializeChildren() {
    }
}

