/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.view.subset;

import com.quantum.Messages;
import com.quantum.util.connection.NotConnectedException;
import com.quantum.util.xml.XMLUtil;
import com.quantum.view.bookmark.ColumnNode;
import com.quantum.view.bookmark.TreeNode;
import com.quantum.view.subset.ObjectNode;
import com.quantum.view.subset.SubsetNode;
import com.quantum.view.subset.SubsetRoot;
import java.sql.SQLException;
import java.util.Vector;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class SubsetContentProvider
implements ITreeContentProvider {
    private Vector subsets = new Vector();
    private static SubsetContentProvider instance = null;
    private boolean hasChanged = false;

    public static synchronized SubsetContentProvider getInstance() {
        if (instance == null) {
            instance = new SubsetContentProvider();
        }
        return instance;
    }

    private SubsetContentProvider() {
    }

    public void exportXML(Element root) {
        System.out.println("Subsets: Saving to Element");
        Element subsetRoot = XMLUtil.createElementText(root, Messages.getString("ExportXMLAction.Subsets"), "");
        int i = 0;
        while (i < this.subsets.size()) {
            SubsetNode current = (SubsetNode)this.subsets.get(i);
            current.exportXML(subsetRoot);
            ++i;
        }
    }

    public void importXML(Element root) {
        System.out.println("Bookmarks: Loading from Element");
        Vector<SubsetNode> newSubsets = new Vector<SubsetNode>();
        NodeList nodes = root.getElementsByTagName(Messages.getString("ExportXMLAction.Subset"));
        int i = 0;
        while (i < nodes.getLength()) {
            SubsetNode subset = new SubsetNode();
            Element node = (Element)nodes.item(i);
            subset.importXML(node, true);
            newSubsets.add(subset);
            ++i;
        }
        this.subsets = newSubsets;
    }

    public Object[] getChildren(Object parentElement) {
        if (parentElement.equals(SubsetRoot.ROOT)) {
            return this.subsets.toArray();
        }
        if (parentElement instanceof TreeNode) {
            TreeNode node = (TreeNode)parentElement;
            try {
                return node.getChildren();
            }
            catch (NotConnectedException notConnectedException) {
            }
            catch (SQLException sQLException) {}
        }
        return SubsetRoot.EMPTY_ARRAY;
    }

    public Object[] getElements(Object inputElement) {
        return this.getChildren(inputElement);
    }

    public Object getParent(Object element) {
        if (element.equals(SubsetRoot.ROOT)) {
            return null;
        }
        if (element instanceof TreeNode) {
            TreeNode node = (TreeNode)element;
            return node.getParent();
        }
        return null;
    }

    public boolean hasChildren(Object element) {
        if (element.equals(SubsetRoot.ROOT)) {
            return true;
        }
        if (element instanceof TreeNode) {
            TreeNode node = (TreeNode)element;
            return node.hasChildren();
        }
        return false;
    }

    public void setChildren(SubsetNode b, Vector tables) {
        b.setChildren(tables);
    }

    public void addSubset(SubsetNode b) {
        this.hasChanged = true;
        if (!this.subsets.contains(b)) {
            this.subsets.addElement(b);
        }
    }

    public void removeSubset(SubsetNode b) {
        this.hasChanged = true;
        if (this.subsets.contains(b)) {
            this.subsets.removeElement(b);
        }
    }

    public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
    }

    public void dispose() {
    }

    public boolean hasChanged() {
        return this.hasChanged;
    }

    public int getSize() {
        return this.subsets.size();
    }

    public void setHasChanged(boolean b) {
        this.hasChanged = b;
    }

    public void deleteColumn(ColumnNode column) {
    }

    public void deleteObject(ObjectNode object) {
        SubsetNode node = (SubsetNode)object.getParent();
        if (!(node instanceof SubsetNode)) {
            return;
        }
        node.remove(object);
        this.setHasChanged(true);
    }
}

