/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.view.subset;

import com.quantum.model.Bookmark;
import com.quantum.model.BookmarkCollection;
import com.quantum.model.Check;
import com.quantum.model.Column;
import com.quantum.model.DatabaseObject;
import com.quantum.model.Entity;
import com.quantum.model.ForeignKey;
import com.quantum.model.Index;
import com.quantum.model.Privilege;
import com.quantum.model.Schema;
import com.quantum.model.Trigger;
import com.quantum.util.connection.NotConnectedException;
import java.sql.SQLException;

public class EntitySubset
implements Entity {
    private String name;
    private String schema;
    private Column[] columns;
    private String bookmarkName;

    public EntitySubset(String name, String schema, Column[] columns, String bookmarkName) {
        this.name = name;
        this.schema = schema;
        this.columns = columns;
        this.bookmarkName = bookmarkName;
    }

    public String getName() {
        return this.name;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getType() {
        return null;
    }

    public Column[] getColumns() {
        return this.columns;
    }

    public Index[] getIndexes() {
        return new Index[0];
    }

    public String getDisplayName() {
        return this.getQualifiedName();
    }

    public Column getColumn(String columnName) {
        int i = 0;
        while (i < this.columns.length) {
            if (columnName.equals(this.columns[i].getName())) {
                return this.columns[i];
            }
            ++i;
        }
        return null;
    }

    public String getQualifiedName() {
        return String.valueOf(this.schema) + "." + this.name;
    }

    public Boolean exists() {
        return null;
    }

    public Bookmark getBookmark() {
        return BookmarkCollection.getInstance().find(this.bookmarkName);
    }

    private DatabaseObject getObjectFromBookmark() {
        try {
            return this.getBookmark().getObject(new Schema(this.schema), this.name);
        }
        catch (SQLException sQLException) {
            return null;
        }
    }

    public String getQuotedTableName() {
        return this.getBookmark().filterQuoteName(this.getQualifiedName());
    }

    public int compareTo(Object arg0) {
        return 0;
    }

    public ForeignKey[] getExportedKeys() throws NotConnectedException, SQLException {
        return null;
    }

    public ForeignKey[] getImportedKeys() throws NotConnectedException, SQLException {
        return null;
    }

    public ForeignKey[] getReferences() throws NotConnectedException, SQLException {
        return null;
    }

    public boolean isSynonym() {
        return false;
    }

    public String getCreateStatement() throws NotConnectedException, SQLException {
        return null;
    }

    public Column[] getPrimaryKeyColumns() throws NotConnectedException, SQLException {
        return null;
    }

    public Trigger[] getTriggers() throws NotConnectedException, SQLException {
        return null;
    }

    public Check[] getChecks() throws NotConnectedException, SQLException {
        return null;
    }

    public Privilege[] getPrivileges() throws NotConnectedException, SQLException {
        return null;
    }
}

