/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.view.bookmark;

import com.quantum.model.Bookmark;
import com.quantum.model.Schema;
import com.quantum.model.SchemaHolder;
import com.quantum.util.connection.NotConnectedException;
import com.quantum.view.bookmark.BookmarkListNode;
import com.quantum.view.bookmark.GroupNode;
import com.quantum.view.bookmark.TreeNode;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Iterator;

public class SchemaNode
extends TreeNode
implements SchemaHolder {
    private Schema schema;

    public SchemaNode(TreeNode parent, Schema schema) {
        super(parent);
        this.schema = schema;
    }

    public Object[] getChildren() {
        Bookmark bookmark = this.getBookmark();
        if (!bookmark.isConnected()) {
            return BookmarkListNode.EMPTY_ARRAY;
        }
        if (this.children.isEmpty()) {
            this.initializeChildren();
        }
        return this.children.toArray(new TreeNode[this.children.size()]);
    }

    protected void initializeChildren() {
        boolean firstTimeInitialization = this.children.isEmpty();
        boolean changed = false;
        HashMap<String, GroupNode> temp = new HashMap<String, GroupNode>();
        Iterator i = this.children.iterator();
        while (i.hasNext()) {
            GroupNode element = (GroupNode)i.next();
            temp.put(element.getType(), element);
        }
        this.children.clear();
        Bookmark bookmark = this.getBookmark();
        try {
            String[] types = bookmark.getDatabase().getEntityTypes();
            int i2 = 0;
            int length = types == null ? 0 : types.length;
            while (i2 < length) {
                GroupNode node = (GroupNode)temp.remove(types[i2]);
                if (node == null) {
                    this.children.add(new GroupNode(this, this.schema, types[i2]));
                    changed = true;
                } else {
                    this.children.add(node);
                }
                ++i2;
            }
            Iterator i22 = temp.values().iterator();
            while (i22.hasNext()) {
                ((GroupNode)i22.next()).dispose();
                changed = true;
            }
            if (!firstTimeInitialization && changed) {
                this.firePropertyChange("children", null, null);
            }
        }
        catch (NotConnectedException notConnectedException) {
        }
        catch (SQLException sQLException) {}
    }

    public boolean hasChildren() {
        return this.getBookmark().isConnected();
    }

    public String getName() {
        return this.schema.getDisplayName();
    }

    protected String getImageName() {
        return this.schema.exists() ? "schema.gif" : "missingschema.gif";
    }

    public Schema getSchema() {
        return this.schema;
    }
}

