/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.view.bookmark;

import com.quantum.model.Procedure;
import com.quantum.model.ProcedureArgument;
import com.quantum.util.connection.NotConnectedException;
import com.quantum.view.bookmark.ArgumentNode;
import com.quantum.view.bookmark.BookmarkListNode;
import com.quantum.view.bookmark.DbObjectNode;
import com.quantum.view.bookmark.TreeNode;
import java.sql.SQLException;
import java.util.Map;

public class ProcedureNode
extends DbObjectNode {
    boolean initialized = false;

    public ProcedureNode(TreeNode parent, Procedure object) {
        super(parent, object, false);
    }

    protected String getImageName() {
        return "procedure";
    }

    public Procedure getProcedure() {
        return (Procedure)this.getDatabaseObject();
    }

    public void setProcedure(Procedure procedure) {
        this.setDatabaseObject(procedure);
    }

    public Object[] getChildren() throws NotConnectedException, SQLException {
        if (!this.isInitialized()) {
            this.initializeChildren();
        }
        if (this.children.size() > 0) {
            return this.children.toArray(new ArgumentNode[this.children.size()]);
        }
        return BookmarkListNode.EMPTY_ARRAY;
    }

    public boolean hasChildren() {
        return true;
    }

    protected void initializeChildren() throws SQLException, NotConnectedException {
        boolean wasInitialized = this.isInitialized();
        Map map = this.getChildrenAsMap();
        ProcedureArgument[] arguments = this.getProcedure().getArguments();
        this.children.clear();
        int i = 0;
        int length = arguments == null ? 0 : arguments.length;
        while (i < length) {
            if (arguments[i] != null) {
                ArgumentNode node = (ArgumentNode)map.get(arguments[i].getName());
                if (node == null) {
                    this.children.add(new ArgumentNode(this, arguments[i]));
                } else {
                    node.setProcedureArgument(arguments[i]);
                    this.children.add(node);
                }
                if (wasInitialized) {
                    this.firePropertyChange("arguments", null, null);
                }
            }
            ++i;
        }
    }
}

