/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.view.bookmark;

import com.quantum.model.Column;
import com.quantum.model.Entity;
import com.quantum.model.EntityHolder;
import com.quantum.model.Table;
import com.quantum.model.View;
import com.quantum.util.connection.NotConnectedException;
import com.quantum.view.bookmark.BookmarkListNode;
import com.quantum.view.bookmark.ColumnNode;
import com.quantum.view.bookmark.DbObjectNode;
import com.quantum.view.bookmark.LabelDecorationInstructions;
import com.quantum.view.bookmark.TreeNode;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;

public class EntityNode
extends DbObjectNode
implements EntityHolder {
    private List columns = Collections.synchronizedList(new ArrayList());
    private List foreignKeys = Collections.synchronizedList(new ArrayList());

    public EntityNode(TreeNode parent, Entity entity) {
        super(parent, entity, false);
    }

    public EntityNode(TreeNode parent, Entity entity, boolean longFormName) {
        super(parent, entity, longFormName);
    }

    public Object[] getChildren() throws NotConnectedException, SQLException {
        if (!this.isInitialized()) {
            this.initializeChildren();
        }
        if (this.children.size() > 0) {
            return this.children.toArray(new ColumnNode[this.children.size()]);
        }
        return BookmarkListNode.EMPTY_ARRAY;
    }

    protected synchronized void initializeChildren() throws NotConnectedException, SQLException {
        boolean wasInitialized = this.isInitialized();
        Map map = this.getChildrenAsMap();
        Column[] columns = this.getEntity().getColumns();
        this.children.clear();
        int i = 0;
        int length = columns == null ? 0 : columns.length;
        while (i < length) {
            ColumnNode node = (ColumnNode)map.get(columns[i].getName());
            if (node == null) {
                this.children.add(new ColumnNode(this, columns[i]));
            } else {
                node.setColumn(columns[i]);
                this.children.add(node);
            }
            if (wasInitialized) {
                this.firePropertyChange("columns", null, null);
            }
            ++i;
        }
    }

    public boolean hasChildren() {
        return !this.isSequence();
    }

    public Entity getEntity() {
        return (Entity)this.getDatabaseObject();
    }

    public boolean isTable() {
        return "TABLE".equals(this.getEntity().getType());
    }

    public boolean isView() {
        return "VIEW".equals(this.getEntity().getType());
    }

    public boolean isSequence() {
        return "SEQUENCE".equals(this.getEntity().getType());
    }

    protected String getImageName() {
        if (this.isSequence()) {
            return "sequence.gif";
        }
        if (this.isView()) {
            return "view.gif";
        }
        if (this.getEntity().exists() == null || this.getEntity().exists().booleanValue()) {
            if (this.getEntity().isSynonym()) {
                return "big_syn_table.gif";
            }
            return "bigtable.gif";
        }
        return "missingtable.gif";
    }

    public String getLabelDecorations(LabelDecorationInstructions instructions) {
        Integer size;
        String decoration = null;
        if (instructions.isSizeVisible() && (size = this.getSize()) != null) {
            decoration = String.valueOf(decoration == null ? "" : decoration) + "[" + size + "]";
        }
        return decoration;
    }

    private Integer getSize() {
        if (this.isTable()) {
            return ((Table)this.getEntity()).getSize();
        }
        if (this.isView()) {
            return ((View)this.getEntity()).getSize();
        }
        return null;
    }

    public int compareTo(Object o) {
        if (o instanceof EntityNode) {
            EntityNode that = (EntityNode)o;
            return this.getEntity().getQualifiedName().compareTo(that.getEntity().getQualifiedName());
        }
        return super.compareTo(o);
    }
}

