/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.view.beanshell;

import bsh.Interpreter;
import com.quantum.view.beanshell.BeanShellActionGroup;
import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import org.eclipse.swt.custom.StyleRange;
import org.eclipse.swt.custom.StyledText;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.part.ViewPart;

public class BeanShellView
extends ViewPart {
    public static final int ALL = 1;
    public static final int ALL_BUT_SCRIPT = 2;
    public static final int OUTPUT = 3;
    public static final int ERROR = 4;
    private Interpreter interpreter = null;
    private StyledText widget;
    private BeanShellActionGroup actionGroup;
    private ByteArrayOutputStream outStr;
    private ByteArrayOutputStream errStr;

    public void createPartControl(Composite parent) {
        this.outStr = new ByteArrayOutputStream();
        PrintStream printOut = new PrintStream(this.outStr);
        this.errStr = new ByteArrayOutputStream();
        PrintStream printErr = new PrintStream(this.errStr);
        this.interpreter = new Interpreter(null, printOut, printErr, false);
        this.widget = new StyledText(parent, 768);
        this.widget.setEditable(true);
        String initialComment = "";
        this.widget.setText(initialComment);
        this.actionGroup = new BeanShellActionGroup(this);
        this.actionGroup.fillActionBars(this.getViewSite().getActionBars());
    }

    public void setFocus() {
    }

    public String getScriptText() {
        this.getSite().getShell().getDisplay();
        int numLin = this.widget.getLineCount();
        String scriptText = "";
        int i = 0;
        while (i < numLin) {
            StyleRange style;
            int endOffset;
            int offset = this.widget.getOffsetAtLine(i);
            int n = endOffset = i + 1 < numLin ? this.widget.getOffsetAtLine(i + 1) - 1 : this.widget.getCharCount() - 1;
            if (offset > endOffset) {
                offset = endOffset;
            }
            if ((style = this.widget.getStyleRangeAtOffset(offset)) == null) {
                scriptText = String.valueOf(scriptText) + this.widget.getText(offset, endOffset);
            }
            ++i;
        }
        return scriptText;
    }

    public String getOutputText() {
        Display display = this.getSite().getShell().getDisplay();
        int numLin = this.widget.getLineCount();
        String outputText = "";
        int i = 0;
        while (i < numLin) {
            StyleRange style;
            int endOffset;
            int offset = this.widget.getOffsetAtLine(i);
            int n = endOffset = i + 1 < numLin ? this.widget.getOffsetAtLine(i + 1) - 1 : this.widget.getCharCount() - 1;
            if (offset > endOffset) {
                offset = endOffset;
            }
            if ((style = this.widget.getStyleRangeAtOffset(offset)) != null && style.background.equals((Object)display.getSystemColor(15))) {
                outputText = String.valueOf(outputText) + this.widget.getText(offset, endOffset);
            }
            ++i;
        }
        return outputText;
    }

    public Interpreter getInterpreter() {
        return this.interpreter;
    }

    public void updateText() {
        String textOut = this.outStr.toString();
        String textErr = this.errStr.toString();
        int outChar = this.widget.getCharCount();
        this.widget.append(String.valueOf(this.widget.getLineDelimiter()) + textOut);
        Display display = this.getSite().getShell().getDisplay();
        this.widget.setStyleRange(new StyleRange(outChar, textOut.length(), display.getSystemColor(21), display.getSystemColor(15)));
        outChar = this.widget.getCharCount();
        this.widget.append(String.valueOf(this.widget.getLineDelimiter()) + textErr);
        this.widget.setStyleRange(new StyleRange(outChar, textErr.length(), display.getSystemColor(3), display.getSystemColor(1)));
    }

    public ByteArrayOutputStream getOutput() {
        return this.outStr;
    }

    public ByteArrayOutputStream getError() {
        return this.errStr;
    }

    public void clear(int part) {
        if (part == 1) {
            this.widget.replaceTextRange(0, this.widget.getCharCount(), "");
        } else if (part == 2) {
            StyleRange[] ranges = this.widget.getStyleRanges();
            int i = 0;
            while (i < ranges.length) {
                StyleRange range = ranges[i];
                this.widget.replaceTextRange(range.start, range.length, "");
                ++i;
            }
        }
    }

    public void setText(String string) {
        this.widget.setText(string);
    }
}

