/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.view;

import com.quantum.Messages;
import com.quantum.QuantumPlugin;
import com.quantum.log.QuantumLog;
import com.quantum.model.Bookmark;
import com.quantum.sql.MultiSQLServer;
import com.quantum.sql.SQLResults;
import com.quantum.ui.dialog.SQLExceptionDialog;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.sql.Connection;
import java.sql.SQLException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;

public class ViewHelper {
    public static SQLResults tryGetResults(IViewPart view, Bookmark bookmark, Connection con, String query) {
        return ViewHelper.tryGetResults(view.getSite().getShell(), bookmark, con, query);
    }

    public static SQLResults tryGetResults(Shell shell, Bookmark bookmark, Connection con, String query) {
        try {
            MultiSQLServer server = MultiSQLServer.getInstance();
            return server.execute(bookmark, con, query);
        }
        catch (SQLException e) {
            QuantumLog.getInstance().error(e.getLocalizedMessage(), e);
            SQLExceptionDialog.openException(shell, bookmark, e);
            return null;
        }
    }

    public static FileOutputStream askSaveFile(String key, Shell shell) {
        return ViewHelper.askSaveFile(key, shell, null, null);
    }

    public static FileOutputStream askSaveFile(String key, Shell shell, String[] filterExt, String[] filterNames) {
        boolean confirmOverwrite;
        FileDialog dialog = new FileDialog(shell, 8192);
        if (filterExt == null) {
            dialog.setFilterExtensions(new String[]{Messages.getString("filedialog." + key + ".filter"), Messages.getString("filedialog.allfiles.filter")});
            dialog.setFilterNames(new String[]{Messages.getString("filedialog." + key + ".name"), Messages.getString("filedialog.allfiles.name")});
        } else {
            dialog.setFilterExtensions(filterExt);
            dialog.setFilterNames(filterNames);
        }
        dialog.setFilterPath(QuantumPlugin.getDefault().getPreferenceStore().getString("quantum.dialogs." + key + ".path"));
        String filename = dialog.open();
        if (filename == null) {
            return null;
        }
        QuantumPlugin.getDefault().getPreferenceStore().setValue("quantum.dialogs." + key + ".path", filename);
        FileOutputStream out = null;
        File target = new File(filename);
        if (target.exists() && Messages.getString("filedialog.options.ConfirmOverwrite").equals("y") && !(confirmOverwrite = MessageDialog.openConfirm((Shell)shell, (String)Messages.getString("filedialog.OverwriteTitle"), (String)Messages.getString("filedialog.OverwriteMsgWithArgument", new Object[]{target.getAbsoluteFile()})))) {
            return null;
        }
        try {
            out = new FileOutputStream(target);
        }
        catch (FileNotFoundException fileNotFoundException) {
            MessageDialog.openConfirm((Shell)shell, (String)Messages.getString("filedialog.message.CannotOpenFileTitle"), (String)(String.valueOf(Messages.getString("filedialog.message.CannotOpenFileMessage")) + filename + Messages.getString("filedialog.message.CannotOpenFileExplain")));
        }
        return out;
    }
}

