/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.view;

import com.quantum.ImageStore;
import com.quantum.Messages;
import com.quantum.model.Bookmark;
import com.quantum.model.Schema;
import com.quantum.ui.dialog.ConnectionUtil;
import com.quantum.ui.dialog.ExceptionDisplayDialog;
import com.quantum.ui.dialog.SQLExceptionDialog;
import com.quantum.ui.dialog.SimpleSelectionDialog;
import com.quantum.util.connection.ConnectionException;
import com.quantum.util.connection.NotConnectedException;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.ISelectionChangedListener;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.viewers.ITableLabelProvider;
import org.eclipse.jface.viewers.SelectionChangedEvent;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;

public class SchemaSelectionControl
extends Composite {
    private final Bookmark bookmarkForConnection;
    private ConnectionUtil connectionUtil = new ConnectionUtil();
    private Set schemas = Collections.synchronizedSet(new HashSet());
    private TableViewer schemaTable;
    private Button useAllSchemasButton;
    private int schemaRule;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport((Object)this);
    private Button useUsernameAsSchemaButton;
    private Button useSelectedSchemasButton;
    private Button removeButton;
    private Button addButton;

    public SchemaSelectionControl(Composite parent, Bookmark bookmarkForConnection) {
        super(parent, 0);
        this.bookmarkForConnection = bookmarkForConnection;
        Schema[] schemas = bookmarkForConnection.getSchemaSelections();
        this.schemas.addAll(Arrays.asList(schemas));
        this.schemaRule = this.bookmarkForConnection.getSchemaRule();
        this.createContents();
    }

    protected void createContents() {
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        this.setLayout((Layout)layout);
        GridData data = new GridData(1808);
        this.setLayoutData(data);
        this.useAllSchemasButton = new Button((Composite)this, 16);
        this.useAllSchemasButton.setText(Messages.getString(((Object)((Object)this)).getClass(), "useAllSchemas"));
        this.useAllSchemasButton.setLayoutData((Object)new GridData(768));
        this.useAllSchemasButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SchemaSelectionControl.this.setSchemaRule(1);
                SchemaSelectionControl.this.updateControls();
            }
        });
        this.useUsernameAsSchemaButton = new Button((Composite)this, 16);
        this.useUsernameAsSchemaButton.setText(Messages.getString(((Object)((Object)this)).getClass(), "useUsernameAsSchema"));
        this.useUsernameAsSchemaButton.setLayoutData((Object)new GridData(768));
        this.useUsernameAsSchemaButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SchemaSelectionControl.this.setSchemaRule(2);
                SchemaSelectionControl.this.updateControls();
            }
        });
        this.useSelectedSchemasButton = new Button((Composite)this, 16);
        this.useSelectedSchemasButton.setText(Messages.getString(((Object)((Object)this)).getClass(), "useSelectedSchemas"));
        this.useSelectedSchemasButton.setLayoutData((Object)new GridData(768));
        this.useSelectedSchemasButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SchemaSelectionControl.this.setSchemaRule(3);
                SchemaSelectionControl.this.updateControls();
            }
        });
        Composite composite = new Composite((Composite)this, 0);
        layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout((Layout)layout);
        data = new GridData(1808);
        composite.setLayoutData((Object)data);
        this.schemaTable = new TableViewer(composite, 67586);
        layout = new GridLayout();
        layout.marginWidth = 5;
        layout.marginHeight = 5;
        this.schemaTable.getTable().setLayout((Layout)layout);
        data = new GridData(1808);
        this.schemaTable.getTable().setLayoutData((Object)data);
        this.schemaTable.setLabelProvider((IBaseLabelProvider)new LabelProviderImpl());
        this.schemaTable.setContentProvider((IContentProvider)new ContentProviderImpl());
        this.schemaTable.setInput((Object)this.schemas);
        this.createButtonArea(composite);
        this.updateControls();
    }

    private void updateControls() {
        this.useAllSchemasButton.setSelection(this.schemaRule == 1);
        this.useUsernameAsSchemaButton.setSelection(this.schemaRule == 2);
        boolean enabled = this.schemaRule != 1 && this.schemaRule != 2;
        this.useSelectedSchemasButton.setSelection(enabled);
        this.schemaTable.getControl().setEnabled(enabled);
        this.addButton.setEnabled(enabled);
        this.removeButton.setEnabled(enabled && !this.schemaTable.getSelection().isEmpty());
    }

    private void createButtonArea(Composite composite) {
        Composite buttonArea = new Composite(composite, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 1;
        buttonArea.setLayout((Layout)layout);
        GridData data = new GridData(34);
        buttonArea.setLayoutData((Object)data);
        this.addButton = new Button(buttonArea, 0);
        this.addButton.setText("Add");
        data = new GridData(770);
        this.addButton.setLayoutData((Object)data);
        this.addButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SchemaSelectionControl.this.addSchema();
            }
        });
        this.removeButton = new Button(buttonArea, 0);
        this.removeButton.setText("Remove");
        this.removeButton.setEnabled(false);
        data = new GridData(770);
        this.removeButton.setLayoutData((Object)data);
        this.removeButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                SchemaSelectionControl.this.removeSchema(SchemaSelectionControl.this.schemaTable.getSelection());
            }
        });
        this.schemaTable.addSelectionChangedListener(new ISelectionChangedListener(){

            public void selectionChanged(SelectionChangedEvent event) {
                SchemaSelectionControl.this.updateControls();
            }
        });
    }

    private void addSchema() {
        boolean confirmed;
        Bookmark bookmark = this.getBookmark();
        boolean isAlreadyConnected = bookmark.isConnected();
        if (!isAlreadyConnected && (confirmed = MessageDialog.openConfirm((Shell)this.getShell(), (String)Messages.getString(((Object)((Object)this)).getClass(), "connectTitle"), (String)Messages.getString(((Object)((Object)this)).getClass(), "connectMessage")))) {
            this.connectionUtil.connect(bookmark, this.getShell());
        }
        try {
            if (bookmark.isConnected()) {
                List schemaList = this.getAllUnselectedSchemas(bookmark);
                SimpleSelectionDialog dialog = new SimpleSelectionDialog(this.getShell(), Messages.getString(((Object)((Object)this)).getClass(), "addSchemaDialog"), schemaList.toArray(), ImageStore.getImage("schema"), true);
                int result = dialog.open();
                if (result == 0 && !dialog.getSelection().isEmpty()) {
                    Iterator i = dialog.getSelection().iterator();
                    while (i.hasNext()) {
                        this.schemas.add(i.next());
                    }
                    this.refreshTable();
                    this.propertyChangeSupport.firePropertyChange("schemas", null, this.getSchemas());
                }
                if (!isAlreadyConnected) {
                    bookmark.disconnect();
                }
            }
        }
        catch (ConnectionException e) {
            ExceptionDisplayDialog.openError(this.getShell(), null, null, e);
        }
        catch (SQLException e) {
            SQLExceptionDialog.openException(this.getShell(), bookmark, e);
        }
    }

    private List getAllUnselectedSchemas(Bookmark bookmark) throws NotConnectedException, SQLException {
        Schema[] schemas = bookmark.getDatabase().getSchemas();
        ArrayList<Schema> schemaList = new ArrayList<Schema>(Arrays.asList(schemas));
        schemaList.removeAll(this.schemas);
        Collections.sort(schemaList);
        return schemaList;
    }

    private void removeSchema(ISelection selection) {
        IStructuredSelection structuredSelection = (IStructuredSelection)selection;
        Iterator i = structuredSelection.iterator();
        while (i.hasNext()) {
            Schema element = (Schema)i.next();
            this.schemas.remove(element);
        }
        this.refreshTable();
        this.propertyChangeSupport.firePropertyChange("schemas", null, this.getSchemas());
    }

    private Bookmark getBookmark() {
        return this.bookmarkForConnection;
    }

    private void refreshTable() {
        this.schemaTable.refresh();
    }

    public Schema[] getSchemas() {
        return this.schemas.toArray(new Schema[this.schemas.size()]);
    }

    public void setSchemas(Schema[] schemas) {
        this.schemas.clear();
        this.schemas.addAll(Arrays.asList(schemas));
        this.updateControls();
        this.refreshTable();
        this.propertyChangeSupport.firePropertyChange("schemas", null, this.getSchemas());
    }

    public void addPropertyChangeListener(PropertyChangeListener arg0) {
        this.propertyChangeSupport.addPropertyChangeListener(arg0);
    }

    public void removePropertyChangeListener(PropertyChangeListener arg0) {
        this.propertyChangeSupport.removePropertyChangeListener(arg0);
    }

    public int getSchemaRule() {
        return this.schemaRule;
    }

    public void setSchemaRule(int schemaRule) {
        if (schemaRule != this.schemaRule) {
            int original = this.schemaRule;
            this.schemaRule = schemaRule;
            this.updateControls();
            this.refreshTable();
            this.propertyChangeSupport.firePropertyChange("schemaRule", original, schemaRule);
        }
    }

    class ContentProviderImpl
    implements IStructuredContentProvider {
        ContentProviderImpl() {
        }

        public Object[] getElements(Object inputElement) {
            ArrayList list = new ArrayList((Collection)inputElement);
            Collections.sort(list);
            return list.toArray();
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }

    class LabelProviderImpl
    implements ITableLabelProvider {
        LabelProviderImpl() {
        }

        public Image getColumnImage(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return ImageStore.getImage("schema");
            }
            return null;
        }

        public String getColumnText(Object element, int columnIndex) {
            if (columnIndex == 0) {
                return ((Schema)element).getDisplayName();
            }
            return null;
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return "displayName".equals(property);
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }
}

