/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.view;

import com.quantum.ImageStore;
import com.quantum.Messages;
import com.quantum.QuantumPlugin;
import com.quantum.search.SearchEntry;
import com.quantum.search.SearchResults;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.ui.part.ViewPart;

public class SQLSearchResultsTree
extends ViewPart
implements PropertyChangeListener {
    private Tree widget;
    private TreeItem searchItem;
    private Action clearAction = new Action(){

        public void run() {
            SearchResults.getInstance().clear();
        }
    };

    public void createPartControl(Composite parent) {
        this.widget = new Tree(parent, 4);
        IToolBarManager toolBar = this.getViewSite().getActionBars().getToolBarManager();
        this.clearAction.setImageDescriptor(ImageStore.getImageDescriptor("clear"));
        this.clearAction.setToolTipText(Messages.getString("SQLSearchResults.ClearSearch"));
        toolBar.add((IAction)this.clearAction);
        this.refresh(SearchResults.getInstance().getEntries());
        SearchResults.getInstance().addPropertyChangeListener(this);
        this.widget.addListener(3, new Listener(){

            public void handleEvent(Event event) {
                Point point = new Point(event.x, event.y);
                TreeItem item = SQLSearchResultsTree.this.widget.getItem(point);
                if (item != null) {
                    String assist = (String)item.getData();
                    if (assist.equals("Table")) {
                        SQLSearchResultsTree.this.tableClicked(event, item);
                    } else if (assist.equals("Column")) {
                        SQLSearchResultsTree.this.columnClicked(event, item);
                    } else if (assist.equals("Value")) {
                        SQLSearchResultsTree.this.valueClicked(event, item);
                    } else if (assist.equals("Key")) {
                        SQLSearchResultsTree.this.keyClicked(event, item);
                    }
                }
            }
        });
    }

    private void tableClicked(Event event, TreeItem item) {
    }

    private void columnClicked(Event event, TreeItem item) {
    }

    private void valueClicked(Event event, TreeItem item) {
    }

    private void keyClicked(Event event, TreeItem item) {
    }

    private void addEntry(SearchEntry entry) {
        if (entry.isFullyQualified()) {
            String text = entry.getTable();
            TreeItem[] items = this.searchItem.getItems();
            int index = 0;
            while (index < items.length && !items[index].getText().equals(text)) {
                ++index;
            }
            if (index == items.length) {
                TreeItem table = this.addTableItem(text);
                TreeItem column = this.addColumnItem(entry, table);
                this.addValueItem(entry, column);
            } else {
                TreeItem table = items[index];
                items = table.getItems();
                index = 0;
                while (index < items.length && !items[index].getText().equals(entry.getColumn())) {
                    ++index;
                }
                if (index == items.length) {
                    TreeItem column = this.addColumnItem(entry, table);
                    this.addValueItem(entry, column);
                } else {
                    TreeItem column = items[index];
                    this.addValueItem(entry, column);
                }
            }
        } else {
            String kw = entry.getKeyword();
            if (kw.equals("Search")) {
                this.searchItem = new TreeItem(this.widget, 0);
                this.searchItem.setText(entry.getMessage());
                this.searchItem.setImage(ImageStore.getImage("search_results_view"));
            }
        }
    }

    private void addValueItem(SearchEntry entry, TreeItem column) {
        TreeItem value = new TreeItem(column, 0);
        value.setText(entry.getValue());
        value.setImage(ImageStore.getImage("value"));
        if (!entry.getPrimaryKey().equals("{}")) {
            TreeItem key = new TreeItem(value, 0);
            key.setText(entry.getPrimaryKey());
            key.setImage(ImageStore.getImage("keycolumn"));
            key.setData((Object)"Key");
        }
        value.setData((Object)"Value");
    }

    private TreeItem addColumnItem(SearchEntry entry, TreeItem table) {
        TreeItem column = new TreeItem(table, 0);
        column.setText(entry.getColumn());
        if (entry.getPrimaryKey().indexOf(entry.getColumn()) != -1) {
            column.setImage(ImageStore.getImage("keycolumn"));
        } else {
            column.setImage(ImageStore.getImage("column"));
        }
        column.setData((Object)"Column");
        return column;
    }

    private TreeItem addTableItem(String text) {
        TreeItem table = new TreeItem(this.searchItem, 0);
        table.setText(text);
        table.setImage(ImageStore.getImage("bigtable"));
        table.setData((Object)"Table");
        return table;
    }

    public static SQLSearchResultsTree getInstance() {
        return (SQLSearchResultsTree)QuantumPlugin.getDefault().getView("com.quantum.view.SQLSearchResults");
    }

    public void dispose() {
        SearchResults.getInstance().removePropertyChangeListener(this);
        super.dispose();
    }

    public void setFocus() {
        this.widget.setFocus();
    }

    public void propertyChange(final PropertyChangeEvent event) {
        if ("entries".equals(event.getPropertyName())) {
            this.getViewSite().getShell().getDisplay().asyncExec(new Runnable(){

                public void run() {
                    if (event.getNewValue() == null) {
                        SearchEntry[] entries = SearchResults.getInstance().getEntries();
                        SQLSearchResultsTree.this.refresh(entries);
                    } else {
                        SQLSearchResultsTree.this.addEntry((SearchEntry)event.getNewValue());
                    }
                }
            });
        }
    }

    private void refresh(SearchEntry[] entries) {
        this.widget.removeAll();
        int i = 0;
        int length = entries == null ? 0 : entries.length;
        while (i < length) {
            this.addEntry(entries[i]);
            ++i;
        }
    }
}

