/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.util.xml;

import org.w3c.dom.Attr;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class XMLRenderer {
    protected boolean insertNewLine = true;
    protected int numberOfTabs = 0;
    protected static final String LINE_SEPARATOR = System.getProperty("line.separator");
    protected static final String INDENT_STRING = "\t";

    protected Attr[] sortAttributes(NamedNodeMap attrs) {
        int len = attrs != null ? attrs.getLength() : 0;
        Attr[] array = new Attr[len];
        int i = 0;
        while (i < len) {
            array[i] = (Attr)attrs.item(i);
            ++i;
        }
        i = 0;
        while (i < len - 1) {
            String name = array[i].getNodeName();
            int index = i;
            int j = i + 1;
            while (j < len) {
                String curName = array[j].getNodeName();
                if (curName.compareTo(name) < 0) {
                    name = curName;
                    index = j;
                }
                ++j;
            }
            if (index != i) {
                Attr temp = array[i];
                array[i] = array[index];
                array[index] = temp;
            }
            ++i;
        }
        return array;
    }

    protected XMLRenderer() {
    }

    protected void newLine(StringBuffer buffer) {
        if (this.insertNewLine) {
            buffer.append(LINE_SEPARATOR);
            int i = 0;
            while (i < this.numberOfTabs) {
                buffer.append(INDENT_STRING);
                ++i;
            }
        }
    }

    protected void print(Node node, StringBuffer buffer) {
        if (node != null) {
            short type = node.getNodeType();
            switch (type) {
                case 9: {
                    this.printDocumentNode(node, buffer);
                    break;
                }
                case 1: {
                    this.printElementNode(node, buffer);
                    break;
                }
                case 5: {
                    this.printEntityReferenceNode(node, buffer);
                    break;
                }
                case 4: {
                    this.printCDataSectionNode(node, buffer);
                    break;
                }
                case 3: {
                    this.printTextNode(node, buffer);
                    break;
                }
                case 7: {
                    this.printProcessingInstructionNode(node, buffer);
                }
            }
        }
    }

    protected void printProcessingInstructionNode(Node node, StringBuffer buffer) {
        buffer.append("<?");
        buffer.append(node.getNodeName());
        String data = node.getNodeValue();
        if (data != null && data.length() > 0) {
            buffer.append(' ');
            buffer.append(data);
        }
        buffer.append("?>");
    }

    protected void printTextNode(Node node, StringBuffer buffer) {
        this.printString(node.getNodeValue(), buffer);
        this.insertNewLine = false;
    }

    protected void printCDataSectionNode(Node node, StringBuffer buffer) {
        buffer.append("<![CDATA[");
        buffer.append(node.getNodeValue());
        buffer.append("]]>");
    }

    protected void printEntityReferenceNode(Node node, StringBuffer buffer) {
        buffer.append('&');
        buffer.append(node.getNodeName());
        buffer.append(';');
    }

    protected void printElementNode(Node node, StringBuffer buffer) {
        this.newLine(buffer);
        ++this.numberOfTabs;
        buffer.append('<');
        buffer.append(node.getNodeName());
        Attr[] attrs = this.sortAttributes(node.getAttributes());
        int i = 0;
        while (i < attrs.length) {
            Attr attr = attrs[i];
            buffer.append(' ');
            buffer.append(attr.getNodeName());
            buffer.append("=\"");
            this.printString(attr.getNodeValue(), buffer);
            buffer.append('\"');
            ++i;
        }
        if (!node.hasChildNodes()) {
            buffer.append(" />");
            --this.numberOfTabs;
        } else {
            buffer.append(">");
            this.printAllChildNodes(node, buffer);
            --this.numberOfTabs;
            this.newLine(buffer);
            buffer.append("</");
            buffer.append(node.getNodeName());
            buffer.append(">");
        }
        this.insertNewLine = true;
    }

    protected void printDocumentNode(Node node, StringBuffer buffer) {
        buffer.append("<?xml version=\"1.0\" ?>");
        this.printAllChildNodes(node, buffer);
    }

    protected void printAllChildNodes(Node node, StringBuffer buffer) {
        NodeList children = node.getChildNodes();
        int i = 0;
        while (i < children.getLength()) {
            this.print(children.item(i), buffer);
            ++i;
        }
    }

    protected void printString(String s, StringBuffer buffer) {
        int len = s != null ? s.length() : 0;
        int i = 0;
        while (i < len) {
            char ch = s.charAt(i);
            switch (ch) {
                case '<': {
                    buffer.append("&lt;");
                    break;
                }
                case '>': {
                    buffer.append("&gt;");
                    break;
                }
                case '&': {
                    buffer.append("&amp;");
                    break;
                }
                case '\"': {
                    buffer.append("&quot;");
                    break;
                }
                default: {
                    buffer.append(ch);
                }
            }
            ++i;
        }
    }

    public static String render(Node node) {
        XMLRenderer renderer = new XMLRenderer();
        StringBuffer buffer = new StringBuffer();
        renderer.print(node, buffer);
        return buffer.toString();
    }

    public static String render(String string) {
        XMLRenderer renderer = new XMLRenderer();
        StringBuffer buffer = new StringBuffer();
        renderer.printString(string, buffer);
        return buffer.toString();
    }
}

