/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.util.xml;

import com.quantum.QuantumPlugin;
import com.quantum.util.xml.XMLRenderer;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringReader;
import java.io.Writer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.w3c.dom.Document;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class XMLHelper {
    private XMLHelper() {
    }

    public static Document createEmptyDocument() throws ParserConfigurationException {
        DocumentBuilder builder = XMLHelper.createDocumentBuilder();
        return builder.newDocument();
    }

    public static Document createFromInputStream(InputStream stream) throws IOException, SAXException, ParserConfigurationException {
        DocumentBuilder builder = XMLHelper.createDocumentBuilder();
        return builder.parse(stream);
    }

    private static DocumentBuilder createDocumentBuilder() throws FactoryConfigurationError, ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        return factory.newDocumentBuilder();
    }

    public static void write(Writer writer, Document document) throws IOException {
        writer.write(XMLRenderer.render(document));
    }

    public static void write(OutputStream stream, Document document) throws IOException {
        stream.write(XMLRenderer.render(document).getBytes());
    }

    public static Document getDocumentFromClipboard() throws ParserConfigurationException, SAXException, IOException {
        TextTransfer transfer = TextTransfer.getInstance();
        return XMLHelper.getDocumentFromString((String)QuantumPlugin.getDefault().getSysClip().getContents((Transfer)transfer));
    }

    public static Document getDocumentFromString(String xmlString) throws SAXException, IOException, ParserConfigurationException {
        if (xmlString == null) {
            return null;
        }
        StringReader text = new StringReader(xmlString);
        InputSource source = new InputSource(text);
        DocumentBuilder builder = XMLHelper.createDocumentBuilder();
        return builder.parse(source);
    }
}

