/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.util.sql;

import java.lang.reflect.Field;
import java.lang.reflect.Modifier;

public class TypesHelper {
    public static final int BIT = -7;
    public static final int TINYINT = -6;
    public static final int SMALLINT = 5;
    public static final int INTEGER = 4;
    public static final int BIGINT = -5;
    public static final int FLOAT = 6;
    public static final int REAL = 7;
    public static final int DOUBLE = 8;
    public static final int NUMERIC = 2;
    public static final int DECIMAL = 3;
    public static final int CHAR = 1;
    public static final int VARCHAR = 12;
    public static final int LONGVARCHAR = -1;
    public static final int DATE = 91;
    public static final int TIME = 92;
    public static final int TIMESTAMP = 93;
    public static final int BINARY = -2;
    public static final int VARBINARY = -3;
    public static final int LONGVARBINARY = -4;
    public static final int NULL = 0;
    public static final int OTHER = 1111;
    public static final int JAVA_OBJECT = 2000;
    public static final int DISTINCT = 2001;
    public static final int STRUCT = 2002;
    public static final int ARRAY = 2003;
    public static final int BLOB = 2004;
    public static final int CLOB = 2005;
    public static final int REF = 2006;
    public static final int DATALINK;
    public static final int BOOLEAN;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    static {
        BOOLEAN = TypesHelper.getType("BOOLEAN", 16);
        DATALINK = TypesHelper.getType("DATALINK", 70);
    }

    public static boolean isFixedSize(int type) {
        return type != 3 && type != 2 && type != 1 && type != 12 && type != -1;
    }

    private static int getType(String typeName, int defaultValue) {
        try {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("java.sql.Types");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Field field = clazz.getField(typeName);
            defaultValue = field.getInt(null);
        }
        catch (NoSuchFieldException noSuchFieldException) {
        }
        catch (IllegalAccessException illegalAccessException) {}
        return defaultValue;
    }

    public static String getTypeName(int type) {
        String name = null;
        try {
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("com.quantum.util.sql.TypesHelper");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            Field[] fields = clazz.getFields();
            int i = 0;
            int length = fields == null ? 0 : fields.length;
            while (name == null && i < length) {
                if (Modifier.isStatic(fields[i].getModifiers()) && Modifier.isPublic(fields[i].getModifiers()) && fields[i].getType() == Integer.TYPE && type == fields[i].getInt(null)) {
                    name = fields[i].getName();
                }
                ++i;
            }
        }
        catch (IllegalAccessException illegalAccessException) {}
        return name;
    }

    public static boolean isReal(int type) {
        return type == 3 || type == 8 || type == 6 || type == 2 || type == 7;
    }

    public static boolean isNumeric(int type) {
        return type == 3 || type == 8 || type == 6 || type == 2 || type == 7 || type == -5 || type == -6 || type == 5 || type == 4;
    }

    public static boolean isText(int type) {
        return type == 1 || type == 12 || type == -1 || type == -2 || type == -3 || type == -4 || type == 2005 || type == 2004;
    }
}

