/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.util.proxy;

import com.quantum.log.QuantumLog;
import com.quantum.util.Displayable;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Driver;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.Statement;

public class ProxyFactory {
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public static Connection createConnectionProxy(Displayable displayable, Connection connection) {
        Class[] classArray = new Class[1];
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("java.sql.Connection");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        classArray[0] = clazz;
        return (Connection)Proxy.newProxyInstance(null, classArray, (InvocationHandler)new ConnectionInvocationHandler(displayable, connection));
    }

    public static Driver createDriverProxy(Displayable displayable, Driver driver) {
        Driver driver2;
        if (driver == null) {
            driver2 = null;
        } else {
            Class[] classArray = new Class[1];
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("java.sql.Driver");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            classArray[0] = clazz;
            driver2 = (Driver)Proxy.newProxyInstance(null, classArray, (InvocationHandler)new DriverInvocationHandler(displayable, driver));
        }
        return driver2;
    }

    public static Object createOtherProxy(String type, Class clazz, Displayable displayable, Object target, Connection connection) {
        return target == null ? null : Proxy.newProxyInstance(null, new Class[]{clazz}, (InvocationHandler)new OtherInvocationHandler(type, displayable, target, connection));
    }

    static abstract class InvocationHandlerImpl
    implements InvocationHandler {
        protected final Displayable displayable;
        private final String type;
        protected final Object target;

        public InvocationHandlerImpl(String type, Displayable displayable, Object target) {
            this.type = type;
            this.displayable = displayable;
            this.target = target;
        }

        public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
            try {
                QuantumLog.getInstance().debug("Invoking " + this.type + "." + method.getName() + "() for \"" + this.displayable.getDisplayName() + "\"");
                Object object = method.invoke(this.target, args);
                return this.handleSpecial(object, proxy);
            }
            catch (InvocationTargetException e) {
                QuantumLog.getInstance().error("Exception in " + this.type + " for \"" + this.displayable.getDisplayName() + "\"", e.getTargetException());
                throw e.getTargetException();
            }
        }

        protected Object handleSpecial(Object object, Object proxy) {
            return object;
        }
    }

    static class ConnectionInvocationHandler
    extends InvocationHandlerImpl {
        static /* synthetic */ Class class$0;
        static /* synthetic */ Class class$1;
        static /* synthetic */ Class class$2;

        public ConnectionInvocationHandler(Displayable displayable, Connection connection) {
            super("Connection", displayable, connection);
        }

        protected Object handleSpecial(Object object, Object proxy) {
            if (object instanceof DatabaseMetaData) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("java.sql.DatabaseMetaData");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return ProxyFactory.createOtherProxy("DatabaseMetaData", clazz, this.displayable, object, (Connection)proxy);
            }
            if (object instanceof PreparedStatement) {
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("java.sql.PreparedStatement");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return ProxyFactory.createOtherProxy("PreparedStatement", clazz, this.displayable, object, (Connection)proxy);
            }
            if (object instanceof Statement) {
                Class<?> clazz = class$2;
                if (clazz == null) {
                    try {
                        clazz = class$2 = Class.forName("java.sql.Statement");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return ProxyFactory.createOtherProxy("Statement", clazz, this.displayable, object, (Connection)proxy);
            }
            return super.handleSpecial(object, proxy);
        }
    }

    static class DriverInvocationHandler
    extends InvocationHandlerImpl {
        public DriverInvocationHandler(Displayable displayable, Driver driver) {
            super("Driver", displayable, driver);
        }

        protected Object handleSpecial(Object object, Object proxy) {
            if (object instanceof Connection) {
                return ProxyFactory.createConnectionProxy(this.displayable, (Connection)object);
            }
            return super.handleSpecial(object, proxy);
        }
    }

    static class OtherInvocationHandler
    extends InvocationHandlerImpl {
        private final Connection connection;
        static /* synthetic */ Class class$0;

        public OtherInvocationHandler(String type, Displayable displayable, Object target, Connection connection) {
            super(type, displayable, target);
            this.connection = connection;
        }

        protected Object handleSpecial(Object object, Object proxy) {
            if (object instanceof Connection) {
                return this.connection;
            }
            if (object instanceof ResultSet) {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("java.sql.ResultSet");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                return ProxyFactory.createOtherProxy("ResultSet", clazz, this.displayable, object, this.connection);
            }
            return super.handleSpecial(object, proxy);
        }
    }
}

