/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.util;

import java.util.Vector;

public class StringMatrix {
    private final int DEFAULT_COLUMNS = 10;
    private final int DEFAULT_ROWS = 10;
    private final int DEFAULT_INCREMENT = 10;
    private Vector header = new Vector(10, 10);
    private Vector matrix = new Vector(10, 10);

    public void addHeader(String header) {
        this.header.add(header);
    }

    private void addVectorHeader(Vector header) {
        this.header.addAll(header);
        int i = 0;
        while (i < this.header.size()) {
            String element = (String)this.header.get(i);
            this.header.setElementAt(element, i);
            ++i;
        }
    }

    public void addMatrixHeader(String[] header) {
        int i = 0;
        while (i < header.length) {
            String element = header[i];
            this.header.add(element);
            ++i;
        }
    }

    public void add(String value, int row) {
        this.grow(row);
        Vector rowVector = (Vector)this.matrix.get(row);
        rowVector.add(value);
    }

    public void add(StringMatrix value) {
        int row = this.matrix.size();
        int i = 0;
        while (i < value.size()) {
            this.grow(row);
            int j = 0;
            while (j < value.getNumColumns()) {
                String header = value.getHeaderColumn(j);
                this.addAt(header, value.get(header, i), row);
                ++j;
            }
            ++row;
            ++i;
        }
        Vector rowVector = (Vector)this.matrix.get(row);
        rowVector.add(value);
    }

    public void copy(StringMatrix origin) {
        this.clear();
        this.add(origin);
    }

    public void clear() {
        this.header.clear();
        this.matrix.clear();
    }

    public void clearValues() {
        this.matrix.clear();
    }

    public void addAt(String key, String value, int row) {
        this.grow(row);
        Vector rowVector = (Vector)this.matrix.get(row);
        int ind = this.header.indexOf(key);
        if (ind < 0) {
            return;
        }
        if (rowVector.size() <= ind) {
            rowVector.setSize(ind);
        }
        rowVector.add(ind, value);
    }

    public void addAt(int column, int row, String value) {
        this.grow(row);
        Vector rowVector = (Vector)this.matrix.get(row);
        if (column >= rowVector.size()) {
            rowVector.setSize(column);
        }
        rowVector.add(column, value);
    }

    private void addVector(Vector value, int row) {
        this.grow(row);
        Vector rowVector = (Vector)this.matrix.get(row);
        rowVector.addAll(value);
    }

    public boolean contains(String key) {
        return this.findKey(key) >= 0;
    }

    public String get(String key, int row) {
        if (this.matrix.size() <= row) {
            return null;
        }
        int col = this.findKey(key);
        if (col < 0) {
            return null;
        }
        Vector rowVector = (Vector)this.matrix.get(row);
        if (rowVector == null) {
            return null;
        }
        return col < rowVector.size() ? (String)rowVector.get(col) : null;
    }

    private int findKey(String key) {
        int i = 0;
        while (i < this.header.size()) {
            String element = (String)this.header.get(i);
            if (element.equalsIgnoreCase(key)) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public Vector getColumn(String key) {
        if (this.size() < 1) {
            return null;
        }
        Vector<String> result = new Vector<String>(this.size(), 1);
        int i = 0;
        while (i < this.size()) {
            result.add(this.get(key, i));
            ++i;
        }
        return result;
    }

    public Vector getUniqueColumn(String key) {
        if (this.size() < 1) {
            return null;
        }
        Vector<String> result = new Vector<String>(this.size(), 1);
        int i = 0;
        while (i < this.size()) {
            if (!result.contains(this.get(key, i))) {
                result.add(this.get(key, i));
            }
            ++i;
        }
        return result;
    }

    public Vector getIndexes(String key, String value) {
        Vector<Integer> result = new Vector<Integer>();
        int i = 0;
        while (i < this.size()) {
            if (this.get(key, i).equals(value)) {
                result.add(new Integer(i));
            }
            ++i;
        }
        return result;
    }

    public void dropMatching(String key, String value) {
        int i = 0;
        while (i < this.size()) {
            if (this.get(key, i).equals(value)) {
                this.deleteRow(i);
            }
            ++i;
        }
    }

    public StringMatrix select(String key, String value) {
        StringMatrix result = new StringMatrix();
        result.addVectorHeader(this.header);
        int j = 0;
        int i = 0;
        while (i < this.size()) {
            if (this.get(key, i).equals(value)) {
                result.addVector((Vector)this.matrix.get(i), j);
                ++j;
            }
            ++i;
        }
        return result;
    }

    private void grow(int row) {
        if (this.matrix.size() <= row) {
            int i = this.matrix.size();
            while (i <= row) {
                this.matrix.add(new Vector(this.header.size(), 1));
                ++i;
            }
        }
    }

    public String get(int col, int row) {
        if (col < 0 || row < 0) {
            return null;
        }
        Vector rowVector = (Vector)this.matrix.get(row);
        if (rowVector == null) {
            return null;
        }
        if (col < rowVector.size()) {
            return (String)rowVector.get(col);
        }
        return null;
    }

    public StringMatrix rowMatrix(int i) {
        StringMatrix result = new StringMatrix();
        result.addVectorHeader(this.header);
        result.addVector((Vector)this.matrix.get(i), 0);
        return result;
    }

    public String[] getRow(int i) {
        if (i < this.matrix.size()) {
            String[] result = new String[this.header.size()];
            Vector resVector = (Vector)this.matrix.get(i);
            resVector.toArray(result);
            return result;
        }
        return null;
    }

    public int size() {
        return this.matrix.size();
    }

    public int getNumColumns() {
        return this.header.size();
    }

    public String getHeaderColumn(int i) {
        if (i < this.header.size()) {
            return (String)this.header.get(i);
        }
        return null;
    }

    public void deleteRow(int i) {
        if (i < this.matrix.size()) {
            this.matrix.remove(i);
        }
    }

    public Object clone() {
        StringMatrix matrix = new StringMatrix();
        matrix.copy(this);
        return matrix;
    }

    public String toString() {
        String result = "";
        int j = 0;
        while (j < this.header.size()) {
            result = String.valueOf(result) + (String)this.header.get(j);
            result = String.valueOf(result) + "\t";
            ++j;
        }
        result = String.valueOf(result) + "\n";
        int i = 0;
        while (i < this.matrix.size()) {
            int j2 = 0;
            while (j2 < this.header.size()) {
                result = String.valueOf(result) + this.get(j2, i);
                result = String.valueOf(result) + "\t";
                ++j2;
            }
            result = String.valueOf(result) + "\n";
            ++i;
        }
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof StringMatrix)) {
            return false;
        }
        StringMatrix sm = (StringMatrix)obj;
        if (!this.header.equals(sm.header)) {
            return false;
        }
        if (this.matrix.size() != sm.matrix.size()) {
            return false;
        }
        int i = 0;
        while (i < this.matrix.size()) {
            Vector smRow;
            Vector row = (Vector)this.matrix.get(i);
            if (!row.equals(smRow = (Vector)sm.matrix.get(i))) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public Vector getMatrix() {
        return this.matrix;
    }

    public String[] getHeader() {
        String[] result = new String[this.header.size()];
        this.header.toArray(result);
        return result;
    }
}

