/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.util;

import com.quantum.QuantumPlugin;
import com.quantum.util.OneLevelConverter;
import com.quantum.util.QuantumUtil;
import com.quantum.util.StringUtil;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.jface.preference.IPreferenceStore;

public class NthLevelConverter {
    private final int DEFAULT_COLUMNS = 10;
    private final int DEFAULT_INCREMENT = 10;
    private Vector upper = new Vector(10, 10);

    public void add(String id, String parentId, int level) {
        OneLevelConverter upperLine = new OneLevelConverter(id);
        if (level == 1) {
            if (!this.upper.contains(upperLine)) {
                this.upper.add(upperLine);
            }
        } else if (level == 0) {
            Vector children;
            int indChildren;
            OneLevelConverter upperItem;
            if (parentId == null) {
                return;
            }
            OneLevelConverter upperFinder = new OneLevelConverter(parentId);
            int ind = this.upper.indexOf(upperFinder);
            if (ind < 0) {
                this.upper.add(upperFinder);
                ind = this.upper.indexOf(upperFinder);
            }
            if ((upperItem = (OneLevelConverter)this.upper.get(ind)).getLower() == null) {
                upperItem.setLower(new Vector(10, 10));
            }
            if ((indChildren = (children = upperItem.getLower()).indexOf(id)) < 0) {
                OneLevelConverter leaf = new OneLevelConverter(id);
                children.add(leaf);
            }
        }
    }

    public Vector getUpper() {
        return this.upper;
    }

    public Vector getLevel(String id, int level) {
        if (level == 1) {
            return this.upper;
        }
        if (level == 0) {
            if (id == null) {
                return null;
            }
            OneLevelConverter upperFinder = new OneLevelConverter(id);
            int ind = this.upper.indexOf(upperFinder);
            if (ind < 0) {
                return null;
            }
            OneLevelConverter upperItem = (OneLevelConverter)this.upper.get(ind);
            return upperItem.getLower();
        }
        return null;
    }

    public void convert(String ind) {
        IPreferenceStore store = QuantumPlugin.getDefault().getPreferenceStore();
        String tableItem = QuantumUtil.trasposeEscape(store.getString("customCopyTableItem" + ind));
        String tableSeparator = QuantumUtil.trasposeEscape(store.getString("customCopyTableSeparator" + ind));
        String columnItem = QuantumUtil.trasposeEscape(store.getString("customCopyColumnItem" + ind));
        String columnSeparator = QuantumUtil.trasposeEscape(store.getString("customCopyColumnSeparator" + ind));
        Iterator iter = this.upper.iterator();
        while (iter.hasNext()) {
            OneLevelConverter oneLevel = (OneLevelConverter)iter.next();
            String upperId = oneLevel.getId();
            Vector lower = oneLevel.getLower();
            if (lower != null) {
                Iterator iterator = lower.iterator();
                while (iterator.hasNext()) {
                    OneLevelConverter element = (OneLevelConverter)iterator.next();
                    String convLeaf = String.valueOf(columnItem) + (iterator.hasNext() ? columnSeparator : "");
                    convLeaf = StringUtil.substituteString(convLeaf, "${schema}", QuantumUtil.getSchemaName(upperId));
                    convLeaf = StringUtil.substituteString(convLeaf, "${qualified}", upperId);
                    convLeaf = StringUtil.substituteString(convLeaf, "${table}", QuantumUtil.getTableName(upperId));
                    convLeaf = StringUtil.substituteString(convLeaf, "${column}", element.getId());
                    element.setResult(convLeaf);
                }
            }
            String convUpper = String.valueOf(tableItem) + (iter.hasNext() ? tableSeparator : "");
            convUpper = StringUtil.substituteString(convUpper, "${schema}", QuantumUtil.getSchemaName(upperId));
            convUpper = StringUtil.substituteString(convUpper, "${qualified}", upperId);
            convUpper = StringUtil.substituteString(convUpper, "${table}", QuantumUtil.getTableName(upperId));
            convUpper = StringUtil.substituteString(convUpper, "${column_list}", this.getColumnList(oneLevel));
            convUpper = StringUtil.substituteString(convUpper, "${create_sql}", this.getColumnList(oneLevel));
            oneLevel.setResult(convUpper);
        }
    }

    private String getColumnList(OneLevelConverter oneLevel) {
        String result = "";
        Vector lower = oneLevel.getLower();
        if (lower != null) {
            Iterator iterator = lower.iterator();
            while (iterator.hasNext()) {
                OneLevelConverter element = (OneLevelConverter)iterator.next();
                result = String.valueOf(result) + element.getResult();
            }
        }
        return result;
    }

    public String getTableList() {
        String result = "";
        Iterator iter = this.upper.iterator();
        while (iter.hasNext()) {
            OneLevelConverter oneLevel = (OneLevelConverter)iter.next();
            result = String.valueOf(result) + oneLevel.getResult();
        }
        return result;
    }
}

