/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.util;

import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.sql.Driver;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;

public class JarUtil {
    private static Hashtable classLoaderCache = new Hashtable();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public static Driver loadDriver(String[] driverFiles, String className) {
        Driver result = null;
        try {
            Class driverClass = JarUtil.loadDriverClass(driverFiles, className);
            if (driverClass != null) {
                try {
                    result = (Driver)driverClass.newInstance();
                }
                catch (ClassCastException classCastException) {}
            }
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
        }
        catch (RuntimeException runtimeException) {}
        return result;
    }

    public static Class loadDriverClass(String[] driverFiles, String className) {
        Class result = null;
        if (driverFiles != null && driverFiles.length > 0 && driverFiles[0].trim().length() > 0 && className != null) {
            try {
                File[] files = JarUtil.getFiles(driverFiles);
                URLClassLoader loader = JarUtil.getURLClassLoader(files);
                result = JarUtil.loadDriverClass(className, loader);
            }
            catch (MalformedURLException malformedURLException) {
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
            }
            catch (RuntimeException runtimeException) {}
        } else if (className != null) {
            try {
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("com.quantum.util.JarUtil");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                result = JarUtil.loadDriverClass(className, clazz.getClassLoader());
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
            }
            catch (RuntimeException runtimeException) {}
        }
        return result;
    }

    private static File[] getFiles(String[] driverFiles) {
        ArrayList<File> list = new ArrayList<File>();
        int i = 0;
        int length = driverFiles == null ? 0 : driverFiles.length;
        while (i < length) {
            File file = new File(driverFiles[i]);
            if (file.exists() && file.isFile()) {
                list.add(file);
            }
            ++i;
        }
        return list.toArray(new File[list.size()]);
    }

    private static Class loadDriverClass(String className, ClassLoader loader) throws ClassNotFoundException {
        Class<?> driverClass = loader.loadClass(className);
        Class<?> clazz = class$1;
        if (clazz == null) {
            try {
                clazz = class$1 = Class.forName("java.sql.Driver");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return clazz.isAssignableFrom(driverClass) ? driverClass : null;
    }

    public static String[] getAllDriverNames(String[] driverFile) {
        ArrayList list = new ArrayList();
        try {
            File[] files = JarUtil.getFiles(driverFile);
            URLClassLoader loader = JarUtil.getURLClassLoader(files);
            int i = 0;
            int length = files == null ? 0 : files.length;
            while (i < length) {
                JarFile jar = new JarFile(files[i]);
                JarUtil.addCandidateDriversToList(list, loader, jar);
                ++i;
            }
        }
        catch (IOException iOException) {}
        return list.toArray(new String[list.size()]);
    }

    private static void addCandidateDriversToList(List list, URLClassLoader loader, JarFile jar) {
        Enumeration<JarEntry> e = jar.entries();
        while (e.hasMoreElements()) {
            JarEntry entry = e.nextElement();
            String className = JarUtil.getClassNameFromFileName(entry.getName());
            if (className == null) continue;
            try {
                Class driverClass = JarUtil.loadDriverClass(className, loader);
                if (driverClass == null) continue;
                list.add(className);
            }
            catch (NoClassDefFoundError noClassDefFoundError) {
            }
            catch (ClassNotFoundException classNotFoundException) {
            }
            catch (RuntimeException runtimeException) {}
        }
    }

    private static String getClassNameFromFileName(String name) {
        String result = null;
        if (name.endsWith(".class")) {
            result = name.substring(0, name.length() - 6).replace('/', '.').replace('\\', '.');
        }
        return result;
    }

    private static URLClassLoader getURLClassLoader(File[] files) throws MalformedURLException {
        String driverPath = JarUtil.getFilePath(files);
        URLClassLoader loader = (URLClassLoader)classLoaderCache.get(driverPath);
        if (loader == null) {
            URL[] urls = new URL[files == null ? 0 : files.length];
            int i = 0;
            int length = urls.length;
            while (i < length) {
                urls[i] = files[i].toURL();
                ++i;
            }
            URLClassLoader uRLClassLoader = loader = urls.length > 0 ? new URLClassLoader(urls) : null;
            if (loader != null) {
                classLoaderCache.put(driverPath, loader);
            }
        }
        return loader;
    }

    private static String getFilePath(File[] files) {
        StringBuffer buffer = new StringBuffer();
        int i = 0;
        int length = files == null ? 0 : files.length;
        while (i < length) {
            buffer.append(files[i].getAbsolutePath());
            if (i < length - 1) {
                buffer.append(File.pathSeparator);
            }
            ++i;
        }
        return buffer.toString();
    }
}

