/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.ui.dialog;

import com.quantum.Messages;
import com.quantum.util.connection.PasswordFinder;
import org.eclipse.jface.dialogs.InputDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class PasswordDialog
extends InputDialog {
    private PasswordFinderImpl passwordFinderImpl;

    protected PasswordDialog(Shell parentShell, String dialogTitle, String dialogMessage, String initialValue, PasswordFinderImpl passwordFinderImpl) {
        super(parentShell, dialogTitle, dialogMessage, initialValue, null);
        this.passwordFinderImpl = passwordFinderImpl;
    }

    protected Control createDialogArea(Composite parent) {
        Control control = super.createDialogArea(parent);
        Text text = this.getText();
        text.setEchoChar('*');
        return control;
    }

    public static PasswordFinder createPasswordFinder(Shell parentShell) {
        PasswordFinderImpl passwordFinder = new PasswordFinderImpl(parentShell);
        return passwordFinder;
    }

    protected void okPressed() {
        this.passwordFinderImpl.setPassword(this.getText().getText());
        super.okPressed();
    }

    static class PasswordFinderImpl
    implements PasswordFinder {
        private boolean passwordMeantToBeSaved = false;
        private String password;
        private boolean prompted = false;
        private Shell shell;

        PasswordFinderImpl(Shell shell) {
            this.shell = shell;
        }

        protected void prompt() {
            PasswordDialog dialog = new PasswordDialog(this.shell, Messages.getString("MultiSQLServer.PasswordNotProvided"), Messages.getString("MultiSQLServer.Enter_Password"), "", this);
            dialog.open();
            this.prompted = true;
        }

        public String getPassword() {
            if (!this.prompted) {
                this.prompt();
            }
            return this.password;
        }

        public boolean isPasswordMeantToBeSaved() {
            if (!this.prompted) {
                this.prompt();
            }
            return this.passwordMeantToBeSaved;
        }

        public void setPassword(String string) {
            this.password = string;
        }

        public void setPasswordMeantToBeSaved(boolean b) {
            this.passwordMeantToBeSaved = b;
        }
    }
}

