/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.ui.dialog;

import com.quantum.Messages;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

public class ExceptionDisplayDialog
extends Dialog {
    private Control detailsArea;
    private Throwable throwable;
    private String message;
    private Button detailsButton;
    private String title;
    private boolean detailsShown = false;
    static /* synthetic */ Class class$0;

    public ExceptionDisplayDialog(Shell parentShell, Throwable throwable) {
        super(parentShell);
        this.throwable = throwable;
    }

    public ExceptionDisplayDialog(Shell parentShell, String dialogTitle, String message, Throwable throwable) {
        super(parentShell);
        this.title = dialogTitle;
        this.message = message;
        this.throwable = throwable;
        this.setShellStyle(67696);
    }

    protected void buttonPressed(int id) {
        if (id == 13) {
            this.toggleDetailsArea();
        } else {
            super.buttonPressed(id);
        }
    }

    protected void configureShell(Shell shell) {
        super.configureShell(shell);
        shell.setText(this.title);
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, IDialogConstants.OK_LABEL, true);
        this.detailsButton = this.createButton(parent, 13, IDialogConstants.SHOW_DETAILS_LABEL, false);
    }

    protected Control createDialogArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        GridData childData = new GridData(1808);
        childData.horizontalSpan = 2;
        composite.setLayoutData((Object)childData);
        composite.setFont(parent.getFont());
        Label label = new Label(composite, 0);
        label.setText(this.message);
        label.setFont(parent.getFont());
        GridData full = new GridData();
        full.horizontalAlignment = 4;
        full.verticalAlignment = 4;
        full.heightHint = this.convertHeightInCharsToPixels(3);
        full.widthHint = this.convertWidthInCharsToPixels(60);
        label.setLayoutData((Object)full);
        return composite;
    }

    protected Control createDetailsArea(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.marginHeight = this.convertVerticalDLUsToPixels(7);
        layout.marginWidth = this.convertHorizontalDLUsToPixels(7);
        layout.verticalSpacing = this.convertVerticalDLUsToPixels(4);
        layout.horizontalSpacing = this.convertHorizontalDLUsToPixels(4);
        composite.setLayout((Layout)layout);
        GridData childData = new GridData(1808);
        childData.horizontalSpan = 2;
        composite.setLayoutData((Object)childData);
        composite.setFont(parent.getFont());
        Label label = new Label(composite, 0);
        label.setText(Messages.getString("ExceptionDisplayDialog.stackTrace"));
        label.setFont(parent.getFont());
        GridData full = new GridData();
        full.horizontalAlignment = 4;
        full.verticalAlignment = 4;
        full.heightHint = this.convertHeightInCharsToPixels(3);
        full.widthHint = this.convertWidthInCharsToPixels(60);
        label.setLayoutData((Object)full);
        Text text = new Text(composite, 2818);
        text.setText(this.throwable.getLocalizedMessage());
        GridData data = new GridData(1808);
        data.heightHint = this.convertHeightInCharsToPixels(8);
        text.setLayoutData((Object)data);
        text.setFont(parent.getFont());
        this.detailsShown = true;
        return composite;
    }

    public static int openError(Shell parentShell, String title, String message, Throwable throwable) {
        if (title == null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.quantum.ui.dialog.ExceptionDisplayDialog");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            title = Messages.getString(String.valueOf(clazz.getName()) + "." + throwable.getClass().getName() + ".title");
        }
        if (message == null) {
            Class<?> clazz = class$0;
            if (clazz == null) {
                try {
                    clazz = class$0 = Class.forName("com.quantum.ui.dialog.ExceptionDisplayDialog");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            message = Messages.getString(String.valueOf(clazz.getName()) + "." + throwable.getClass().getName() + ".message");
        }
        ExceptionDisplayDialog dialog = new ExceptionDisplayDialog(parentShell, title, message, throwable);
        return dialog.open();
    }

    private void toggleDetailsArea() {
        Point windowSize = this.getShell().getSize();
        Point oldSize = this.getShell().computeSize(-1, -1);
        if (this.detailsShown) {
            this.detailsArea.dispose();
            this.detailsShown = false;
            this.detailsButton.setText(IDialogConstants.SHOW_DETAILS_LABEL);
        } else {
            this.detailsArea = this.createDetailsArea((Composite)this.getContents());
            this.detailsButton.setText(IDialogConstants.HIDE_DETAILS_LABEL);
        }
        Point newSize = this.getShell().computeSize(-1, -1);
        this.getShell().setSize(new Point(windowSize.x, windowSize.y + (newSize.y - oldSize.y)));
    }
}

