/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.sql.parser;

import com.quantum.sql.parser.Comment;
import com.quantum.sql.parser.SQL;
import com.quantum.sql.parser.SQLLexx;
import com.quantum.sql.parser.SimpleSQL;
import com.quantum.sql.parser.Token;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;

public class SQLScript {
    private final SQL[] statements;

    SQLScript(SQL[] statements) {
        this.statements = statements;
    }

    public SQL[] getSQLStatements() {
        return this.statements;
    }

    public static SQLScript parse(String text) {
        ArrayList<SQL> statements = new ArrayList<SQL>();
        Vector tokens = SQLLexx.parse(text);
        int start = -1;
        int i = 0;
        int length = tokens == null ? 0 : tokens.size();
        while (i < length) {
            Token token = (Token)tokens.get(i);
            if (token.getType() == 67 && start < 0) {
                statements.add(new Comment(token));
            } else if (token.getType() == 67 && SQLScript.isWhitespace(tokens, start, i)) {
                statements.add(new Comment(tokens.subList(start, i)));
                start = -1;
            } else if (token.getType() == 83) {
                List subList = tokens.subList(start, i);
                statements.add(new SimpleSQL(subList));
                start = -1;
            } else if (start < 0) {
                start = i;
            }
            ++i;
        }
        return new SQLScript(statements.toArray(new SQL[statements.size()]));
    }

    private static boolean isWhitespace(List tokens, int start, int end) {
        boolean whitespace = true;
        List list = tokens.subList(start, end);
        Iterator i = list.iterator();
        while (whitespace && i.hasNext()) {
            Token token = (Token)i.next();
            whitespace &= token.getType() == 87;
        }
        return whitespace;
    }
}

