/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.sql;

import com.quantum.model.Entity;
import com.quantum.sql.FilterSort;
import com.quantum.sql.SQLDate;
import com.quantum.sql.SQLNull;
import com.quantum.sql.SQLResultSetResults;
import com.quantum.sql.Scrollable;
import com.quantum.util.connection.Connectable;
import com.quantum.util.sql.TypesHelper;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;

public class SQLStandardResultSetResults
extends SQLResultSetResults
implements Scrollable {
    private static final int MAX_COLUMN_WIDTH = 2048;
    private boolean hasMore = false;
    private int start = 1;
    private int numberOfRowsPerPage;
    private int totalNumberOfRows = -1;
    private boolean fullMode = false;

    protected SQLStandardResultSetResults(Connectable connectable, String query, Entity entity, int numberOfRowsPerPage) {
        super(query, connectable, entity);
        this.numberOfRowsPerPage = numberOfRowsPerPage;
    }

    static SQLResultSetResults create(ResultSet set, Connectable connectable, String query, Entity entity, int numberOfRows) throws SQLException {
        SQLStandardResultSetResults results = new SQLStandardResultSetResults(connectable, query, entity, numberOfRows);
        results.parseResultSet(set);
        return results;
    }

    protected void parseResultSet(ResultSet set) throws SQLException {
        int rowCount = 1;
        ResultSetMetaData metaData = set.getMetaData();
        int columnCount = metaData.getColumnCount();
        ArrayList<SQLResultSetResults.Column> columns = new ArrayList<SQLResultSetResults.Column>();
        int i = 1;
        while (i <= columnCount) {
            columns.add(new SQLResultSetResults.Column(metaData.getColumnName(i), metaData.getColumnTypeName(i), metaData.getColumnType(i), metaData.getColumnDisplaySize(i)));
            ++i;
        }
        this.setColumns(columns.toArray(new SQLResultSetResults.Column[columns.size()]));
        boolean exitEarly = false;
        int firstRow = this.showAllRecords() ? 0 : this.start;
        int lastRow = this.showAllRecords() ? Integer.MAX_VALUE : this.start + this.numberOfRowsPerPage - 1;
        ArrayList<SQLResultSetResults.Row> rowList = new ArrayList<SQLResultSetResults.Row>();
        while (set.next()) {
            boolean disable;
            boolean bl = disable = this.start < 1 || lastRow < 1;
            if (disable || rowCount >= firstRow && rowCount <= lastRow) {
                ArrayList<Object> row = new ArrayList<Object>();
                int i2 = 1;
                int length = columns.size();
                while (i2 <= length) {
                    Object value = null;
                    try {
                        int type = metaData.getColumnType(i2);
                        value = type == -5 ? set.getBigDecimal(i2) : (type == 3 || type == 2 ? set.getBigDecimal(i2) : (type == 4 ? new Long(set.getLong(i2)) : (type == 5 ? new Integer(set.getInt(i2)) : (type == 91 ? new SQLDate(set.getDate(i2), set.getString(i2)) : (type == 8 ? set.getBigDecimal(i2) : (type == 6 ? set.getBigDecimal(i2) : (type == 93 ? new SQLDate(set.getTimestamp(i2), set.getString(i2)) : (type == 92 ? new SQLDate(set.getTime(i2), set.getString(i2)) : (type == TypesHelper.BOOLEAN || type == TypesHelper.BOOLEAN ? (set.getBoolean(i2) ? Boolean.TRUE : Boolean.FALSE) : (type == -4 || type == -3 || type == 2004 ? this.getEncodedStringFromBinaryStream(set, this.getEncoding(), i2) : (this.getColumn(i2).getSize() < 2048 ? this.getEncodedString(set, this.getEncoding(), i2) : ("".equals(this.getEncoding()) ? this.getStringFromCharacterSteam(set, i2) : this.getEncodedStringFromBinaryStream(set, this.getEncoding(), i2)))))))))))));
                    }
                    catch (IOException iOException) {
                        value = set.getString(i2);
                    }
                    catch (RuntimeException runtimeException) {
                        value = set.getString(i2);
                    }
                    if (value == null && !set.wasNull()) {
                        value = set.getString(i2);
                    }
                    row.add(value == null || set.wasNull() ? SQLNull.SQL_NULL : value);
                    ++i2;
                }
                rowList.add(new SQLResultSetResults.Row(row));
            }
            if (disable || ++rowCount <= lastRow) continue;
            exitEarly = true;
            break;
        }
        if (exitEarly) {
            this.hasMore = set.next();
        } else {
            this.totalNumberOfRows = Math.max(0, rowCount - 1);
            this.hasMore = false;
        }
        this.setRows(rowList.toArray(new SQLResultSetResults.Row[rowList.size()]));
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private String getEncodedStringFromBinaryStream(ResultSet set, String encoding, int columnNumber) throws SQLException, IOException, UnsupportedEncodingException {
        InputStream binaryStream = set.getBinaryStream(columnNumber);
        if (binaryStream == null) {
            return null;
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            int c = binaryStream.read();
            int count = 0;
            while (c >= 0 && count <= 2048) {
                baos.write(c);
                c = binaryStream.read();
                ++count;
            }
        }
        catch (Throwable throwable) {
            Object var8_9 = null;
            binaryStream.close();
            throw throwable;
        }
        {
            Object var8_10 = null;
        }
        binaryStream.close();
        if ("".equals(encoding)) {
            return new String(baos.toByteArray());
        }
        return new String(baos.toByteArray(), encoding);
    }

    private String getStringFromCharacterSteam(ResultSet set, int columnNumber) throws SQLException, IOException {
        Reader reader = set.getCharacterStream(columnNumber);
        if (reader != null) {
            StringBuffer buffer = new StringBuffer();
            int retVal = reader.read();
            int count = 0;
            while (retVal >= 0) {
                buffer.append((char)retVal);
                retVal = reader.read();
                if (++count <= 2048) continue;
                buffer.append("...>>>");
                break;
            }
            reader.close();
            return buffer.toString();
        }
        return null;
    }

    private String getEncodedString(ResultSet set, String encoding, int index) throws SQLException {
        try {
            if (encoding == null || encoding.trim().length() == 0) {
                return set.getString(index);
            }
            byte[] colBytes = set.getBytes(index);
            if (colBytes == null) {
                return null;
            }
            return new String(colBytes, encoding);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            return set.getString(index);
        }
    }

    public boolean hasMore() {
        return this.hasMore;
    }

    public int getTotalNumberOfRows() {
        return this.totalNumberOfRows;
    }

    public void nextPage(Connection connection) throws SQLException {
        if (this.hasNextPage()) {
            this.start += this.numberOfRowsPerPage;
            this.refresh(connection);
        }
    }

    public void previousPage(Connection connection) throws SQLException {
        if (this.hasPreviousPage()) {
            this.start = Math.max(1, this.start - this.numberOfRowsPerPage);
            this.refresh(connection);
        }
    }

    public boolean hasNextPage() {
        return this.hasMore && !this.showAllRecords();
    }

    public boolean hasPreviousPage() {
        return this.start > 1 && !this.showAllRecords();
    }

    public void setFullMode(boolean fullMode) {
        this.fullMode = fullMode;
    }

    public boolean isFullMode() {
        return this.fullMode;
    }

    public int getStart() {
        return this.getRowCount() == 0 ? 0 : (this.showAllRecords() ? 1 : this.start);
    }

    public int getEnd() {
        return this.showAllRecords() ? this.getRowCount() : this.start + this.getRowCount() - 1;
    }

    public int getLast() {
        return this.totalNumberOfRows;
    }

    public void setFilterSort(FilterSort filterSort) {
        super.setFilterSort(filterSort);
        this.start = 1;
    }

    private boolean showAllRecords() {
        return this.numberOfRowsPerPage == 0 || this.fullMode;
    }
}

