/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.sql;

import com.quantum.model.Bookmark;
import com.quantum.model.Entity;
import com.quantum.sql.SQLResultSetResults;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Vector;

public class SQLMetaDataResults
extends SQLResultSetResults {
    private SQLMetaDataResults(String query, Bookmark bookmark, Entity entity) {
        super(query, bookmark, entity);
    }

    static SQLResultSetResults create(Bookmark bookmark, ResultSet set, String query, Entity entity) throws SQLException {
        SQLMetaDataResults results = new SQLMetaDataResults(query, bookmark, entity);
        results.parseResultSet(set);
        return results;
    }

    protected void parseResultSet(ResultSet set) throws SQLException {
        ArrayList<SQLResultSetResults.Column> columns = new ArrayList<SQLResultSetResults.Column>();
        columns.add(new SQLResultSetResults.Column(this, "ColumnName", "", 12, 0));
        columns.add(new SQLResultSetResults.Column(this, "Type Name", "", 12, 0));
        columns.add(new SQLResultSetResults.Column(this, "Size", "", 12, 0));
        columns.add(new SQLResultSetResults.Column(this, "Scale", "", 12, 0));
        columns.add(new SQLResultSetResults.Column(this, "Nullable", "", 12, 0));
        columns.add(new SQLResultSetResults.Column(this, "AutoIncrement", "", 12, 0));
        columns.add(new SQLResultSetResults.Column(this, "Type", "", 12, 0));
        this.setColumns(columns.toArray(new SQLResultSetResults.Column[columns.size()]));
        ResultSetMetaData metaData = set.getMetaData();
        ArrayList<SQLResultSetResults.Row> rowList = new ArrayList<SQLResultSetResults.Row>();
        int i = 1;
        while (i <= metaData.getColumnCount()) {
            Vector<Object> row = new Vector<Object>();
            row.addElement(metaData.getColumnName(i));
            row.addElement(metaData.getColumnTypeName(i));
            long precision = 0L;
            try {
                precision = metaData.getPrecision(i);
            }
            catch (Throwable throwable) {}
            if (precision == 0L) {
                precision = metaData.getColumnDisplaySize(i);
            }
            int scale = metaData.getScale(i);
            row.addElement(new Long(precision));
            row.addElement(new Integer(scale));
            int nullable = metaData.isNullable(i);
            if (nullable == 0) {
                row.addElement("Not Null");
            } else if (nullable == 1) {
                row.addElement("Nullable");
            } else if (nullable == 2) {
                row.addElement("Nullable");
            } else {
                row.addElement("<Error>");
            }
            row.addElement(metaData.isAutoIncrement(i) ? Boolean.TRUE : Boolean.FALSE);
            rowList.add(new SQLResultSetResults.Row(this, row));
            row.addElement(new Integer(metaData.getColumnType(i)));
            ++i;
        }
        this.setRows(rowList.toArray(new SQLResultSetResults.Row[rowList.size()]));
    }

    public boolean isMetaData() {
        return true;
    }
}

