/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.search;

import com.quantum.search.SearchEntry;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class SearchResults {
    private static final SearchResults instance = new SearchResults();
    private List results = Collections.synchronizedList(new ArrayList());
    private int numberOfEntries = 300;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);

    private SearchResults() {
    }

    public static SearchResults getInstance() {
        return instance;
    }

    public void addToResults(String message) {
        SearchEntry searchEntry = new SearchEntry(message);
        this.results.add(searchEntry);
        this.trimResults();
        this.propertyChangeSupport.firePropertyChange("entries", null, searchEntry);
    }

    public void addToResults(String keyword, String message) {
        SearchEntry searchEntry = new SearchEntry(keyword, message);
        this.results.add(searchEntry);
        this.trimResults();
        this.propertyChangeSupport.firePropertyChange("entries", null, searchEntry);
    }

    public void addToResults(String table, String column, String value, String primaryKey) {
        SearchEntry searchEntry = new SearchEntry(table, column, value, primaryKey);
        this.results.add(searchEntry);
        this.trimResults();
        this.propertyChangeSupport.firePropertyChange("entries", null, searchEntry);
    }

    private void trimResults() {
        while (this.results.size() > this.numberOfEntries && !this.results.isEmpty()) {
            this.results.remove(0);
        }
    }

    public SearchEntry[] getEntries() {
        return this.results.toArray(new SearchEntry[this.results.size()]);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void clear() {
        this.results.clear();
        this.propertyChangeSupport.firePropertyChange("entries", null, null);
    }

    public int getNumberOfEntries() {
        return this.numberOfEntries;
    }
}

