/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.search;

public class SearchEntry {
    private final String message;
    private final String table;
    private final String column;
    private final String value;
    private final boolean isFullyQualified;
    private final String keyWord;
    private final String primaryKey;

    SearchEntry(String message) {
        this.table = "";
        this.column = "";
        this.value = "";
        this.primaryKey = "";
        this.message = message;
        this.keyWord = "";
        this.isFullyQualified = false;
    }

    SearchEntry(String keyword, String message) {
        this.table = "";
        this.column = "";
        this.value = "";
        this.primaryKey = "";
        this.message = message;
        this.isFullyQualified = false;
        this.keyWord = keyword;
    }

    SearchEntry(String table, String column, String value) {
        this.table = table;
        this.column = column;
        this.value = value;
        this.primaryKey = "";
        this.message = String.valueOf(table) + ";" + column + ";" + value;
        this.isFullyQualified = true;
        this.keyWord = "";
    }

    SearchEntry(String table, String column, String value, String primaryKey) {
        this.table = table;
        this.column = column;
        this.value = value;
        this.primaryKey = primaryKey;
        this.message = String.valueOf(table) + ";" + column + ";" + value;
        this.isFullyQualified = true;
        this.keyWord = "";
    }

    public String getMessage() {
        return this.message;
    }

    public String getTable() {
        return this.table;
    }

    public String getColumn() {
        return this.column;
    }

    public String getValue() {
        return this.value;
    }

    public String getKeyword() {
        return this.keyWord;
    }

    public String getPrimaryKey() {
        return this.primaryKey;
    }

    public boolean isFullyQualified() {
        return this.isFullyQualified;
    }

    public String toString() {
        if (this.message != null) {
            return this.message;
        }
        return "";
    }
}

