/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.model.xml;

import com.quantum.model.Check;
import com.quantum.model.CheckImpl;
import com.quantum.model.Column;
import com.quantum.model.ColumnImpl;
import com.quantum.model.ForeignKey;
import com.quantum.model.ForeignKeyImpl;
import com.quantum.model.Index;
import com.quantum.model.Privilege;
import com.quantum.model.PrivilegeImpl;
import com.quantum.model.SequenceMetadata;
import com.quantum.model.TableMetadata;
import com.quantum.model.Trigger;
import com.quantum.model.TriggerImpl;
import com.quantum.util.ModelUtil;
import com.quantum.util.connection.NotConnectedException;
import com.quantum.util.xml.XMLUtil;
import java.sql.SQLException;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class XMLToModelConverter
implements TableMetadata,
SequenceMetadata {
    Element root;
    String type;

    public XMLToModelConverter(Element node) {
        this.root = node;
        this.type = this.root.getNodeName();
    }

    public String getName() {
        return XMLUtil.getElementAtribute(this.root, this.type, "name");
    }

    public String getSchema() {
        return XMLUtil.getElementAtribute(this.root, this.type, "schema");
    }

    public String getQualifiedName() {
        String schema = this.getSchema();
        String name = this.getName();
        return schema == null || schema.length() == 0 ? name : String.valueOf(schema) + "." + name;
    }

    public boolean isSynonym() {
        String isSynonym = XMLUtil.getElementAtribute(this.root, this.type, "isSynonym");
        return isSynonym.equals("true");
    }

    public Column[] getColumns() {
        NodeList columnNodes = this.root.getElementsByTagName("column");
        Column[] columns = new Column[columnNodes.getLength()];
        int i = 0;
        while (i < columnNodes.getLength()) {
            Element columnElement = (Element)columnNodes.item(i);
            columns[i] = this.convertColumn(columnElement);
            ++i;
        }
        return columns;
    }

    private Column convertColumn(Element columnElement) {
        int javaType;
        try {
            javaType = Integer.parseInt(columnElement.getAttribute("java.sql.Types"));
        }
        catch (NumberFormatException numberFormatException) {
            return null;
        }
        ColumnImpl newColumn = new ColumnImpl(null, columnElement.getAttribute("name"), columnElement.getAttribute("type"), javaType, columnElement.getAttribute("size").equals("") ? 0L : Long.parseLong(columnElement.getAttribute("size")), columnElement.getAttribute("numberOfFractionalDigits").equals("") ? 0 : Integer.parseInt(columnElement.getAttribute("numberOfFractionalDigits")), "TRUE".equalsIgnoreCase(columnElement.getAttribute("nullable")), Integer.parseInt(columnElement.getAttribute("position")), !columnElement.hasAttribute("defaultValue") ? null : columnElement.getAttribute("defaultValue"), XMLUtil.getElementText(columnElement, "remarks", ""));
        String keyOrder = columnElement.getAttribute("keyOrder");
        newColumn.setPrimaryKeyOrder(keyOrder == "" ? 0 : Integer.decode(keyOrder));
        return newColumn;
    }

    public Index[] getIndexes() throws NotConnectedException, SQLException {
        return null;
    }

    public Column getColumn(String columnName) throws NotConnectedException, SQLException {
        Column[] columns = this.getColumns();
        Column column = null;
        int i = 0;
        int length = columns == null ? 0 : columns.length;
        while (column == null && i < length) {
            if (columnName != null && columnName.equals(columns[i].getName())) {
                column = columns[i];
            }
            ++i;
        }
        return column;
    }

    private ForeignKey convertForeignKey(Element keyElement) {
        ForeignKeyImpl newForeignKey = new ForeignKeyImpl();
        newForeignKey.setName(keyElement.getAttribute("name"));
        newForeignKey.setForeignEntitySchema(keyElement.getAttribute("foreignSchema"));
        newForeignKey.setForeignEntityName(keyElement.getAttribute("foreignTable"));
        newForeignKey.setLocalEntitySchema(keyElement.getAttribute("localSchema"));
        newForeignKey.setLocalEntityName(keyElement.getAttribute("localTable"));
        newForeignKey.setUpdateRule(XMLToModelConverter.foreignKeyRuleToInt(keyElement.getAttribute("onUpdate")));
        newForeignKey.setDeleteRule(XMLToModelConverter.foreignKeyRuleToInt(keyElement.getAttribute("onDelete")));
        NodeList columnNodes = this.root.getElementsByTagName("joinedColumn");
        int i = 0;
        while (i < columnNodes.getLength()) {
            Element element = (Element)columnNodes.item(i);
            newForeignKey.addColumns(element.getAttribute("local"), element.getAttribute("foreign"));
            ++i;
        }
        return newForeignKey;
    }

    private static int foreignKeyRuleToInt(String rule) {
        if (rule == "cascade") {
            return 0;
        }
        if (rule == "noAction") {
            return 3;
        }
        if (rule == "restrict") {
            return 1;
        }
        if (rule == "setDefault") {
            return 4;
        }
        return 2;
    }

    public ForeignKey[] getImportedKeys() throws NotConnectedException, SQLException {
        return this.getForeignKeys(true);
    }

    public ForeignKey[] getExportedKeys() throws NotConnectedException, SQLException {
        return this.getForeignKeys(false);
    }

    private ForeignKey[] getForeignKeys(boolean imported) {
        NodeList foreignKeyNodes = this.root.getElementsByTagName("foreignKey");
        NodeList exportedKeyNodes = XMLUtil.selectNodesOnAttributeValue(foreignKeyNodes, "type", imported ? "imported" : "exported");
        ForeignKey[] key = new ForeignKey[exportedKeyNodes.getLength()];
        int i = 0;
        while (i < exportedKeyNodes.getLength()) {
            Element keyElement = (Element)exportedKeyNodes.item(i);
            key[i] = this.convertForeignKey(keyElement);
            ++i;
        }
        return key;
    }

    public ForeignKey[] getReferences() throws NotConnectedException, SQLException {
        return null;
    }

    public String getCreateStatement() throws NotConnectedException, SQLException {
        return XMLUtil.getElementText(this.root, "createStatement");
    }

    public String getMinValue() {
        return XMLUtil.getElementAtribute(this.root, this.type, "minValue");
    }

    public String getMaxValue() {
        return XMLUtil.getElementAtribute(this.root, this.type, "maxValue");
    }

    public String getInitialValue() {
        return XMLUtil.getElementAtribute(this.root, this.type, "initialValue");
    }

    public String getIncrementBy() {
        return XMLUtil.getElementAtribute(this.root, this.type, "incrementBy");
    }

    public boolean isCycled() {
        return XMLUtil.getElementAtribute(this.root, this.type, "isCycled").equals("true");
    }

    public boolean isOrdered() {
        return XMLUtil.getElementAtribute(this.root, this.type, "isOrdered").equals("true");
    }

    public Column[] getPrimaryKeyColumns() throws NotConnectedException, SQLException {
        return ModelUtil.extractPrimaryKeyColumns(this.getColumns());
    }

    public Trigger[] getTriggers() throws NotConnectedException, SQLException {
        NodeList triggerNodes = this.root.getElementsByTagName("trigger");
        Trigger[] triggers = new Trigger[triggerNodes.getLength()];
        int i = 0;
        while (i < triggerNodes.getLength()) {
            Element triggerElement = (Element)triggerNodes.item(i);
            triggers[i] = this.converTrigger(triggerElement);
            ++i;
        }
        return triggers;
    }

    private Trigger converTrigger(Element triggerElement) {
        TriggerImpl newTrigger = new TriggerImpl(triggerElement.getAttribute("name"), triggerElement.getAttribute("moment"), triggerElement.getAttribute("forEach"), triggerElement.getAttribute("event"), triggerElement.getAttribute("columnName"), triggerElement.getAttribute("language"), triggerElement.getAttribute("referencing"), XMLUtil.getElementText(triggerElement, "whenClause", ""), triggerElement.getAttribute("status"), triggerElement.getAttribute("actionType"), XMLUtil.getElementText(triggerElement, "body", ""));
        return newTrigger;
    }

    public Check[] getChecks() throws NotConnectedException, SQLException {
        NodeList checkNodes = this.root.getElementsByTagName("checkConstraint");
        Check[] checks = new Check[checkNodes.getLength()];
        int i = 0;
        while (i < checkNodes.getLength()) {
            Element checkElement = (Element)checkNodes.item(i);
            checks[i] = new CheckImpl(checkElement.getAttribute("name"), XMLUtil.getElementText(checkElement, "body", ""));
            ++i;
        }
        return checks;
    }

    public Privilege[] getPrivileges() throws NotConnectedException, SQLException {
        NodeList privilegeNodes = this.root.getElementsByTagName("privilege");
        Privilege[] privileges = new Privilege[privilegeNodes.getLength()];
        int i = 0;
        while (i < privilegeNodes.getLength()) {
            Element privilegeElement = (Element)privilegeNodes.item(i);
            privileges[i] = new PrivilegeImpl(privilegeElement.getAttribute("grantor"), privilegeElement.getAttribute("grantee"), privilegeElement.getAttribute("access"), privilegeElement.getAttribute("isGrantable").equals("true"));
            ++i;
        }
        return privileges;
    }
}

