/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.model.xml;

import com.quantum.Messages;
import com.quantum.model.Bookmark;
import com.quantum.model.Check;
import com.quantum.model.Column;
import com.quantum.model.DatabaseObject;
import com.quantum.model.Entity;
import com.quantum.model.ForeignKey;
import com.quantum.model.JDBCDriver;
import com.quantum.model.Privilege;
import com.quantum.model.Schema;
import com.quantum.model.Sequence;
import com.quantum.model.Table;
import com.quantum.model.Trigger;
import com.quantum.model.View;
import com.quantum.util.connection.NotConnectedException;
import com.quantum.util.xml.XMLHelper;
import com.quantum.util.xml.XMLUtil;
import com.quantum.view.bookmark.DbObjectNode;
import com.quantum.view.bookmark.GroupNode;
import com.quantum.view.bookmark.QuickListNode;
import com.quantum.view.bookmark.SchemaNode;
import com.quantum.view.bookmark.TreeNode;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public class ModelToXMLConverter {
    private static final ModelToXMLConverter instance = new ModelToXMLConverter();

    private ModelToXMLConverter() {
    }

    public static ModelToXMLConverter getInstance() {
        return instance;
    }

    public void createRoot(Document document) {
        document.appendChild(document.createElement("SAVED_DATA"));
    }

    public void convert(Element bookmarkRoot, JDBCDriver jdbcDriver) {
        Document document = bookmarkRoot.getOwnerDocument();
        Element driverNode = document.createElement("jdbcDriver");
        driverNode.setAttribute("name", jdbcDriver.getName());
        driverNode.setAttribute("version", jdbcDriver.getVersion());
        driverNode.setAttribute("type", jdbcDriver.getType());
        driverNode.setAttribute("className", jdbcDriver.getClassName());
        String[] fileNames = jdbcDriver.getJarFileNames();
        int i = 0;
        int length = fileNames == null ? 0 : fileNames.length;
        while (i < length) {
            if (fileNames[i] != null) {
                Element fileName = document.createElement("jar");
                fileName.setAttribute("fileName", fileNames[i]);
                driverNode.appendChild(fileName);
            }
            ++i;
        }
        bookmarkRoot.appendChild(driverNode);
    }

    public void convert(Element bookmarkRoot, Bookmark b) {
        Document document = bookmarkRoot.getOwnerDocument();
        Element bookmark = XMLUtil.createElementText(bookmarkRoot, "bookmark", "");
        XMLUtil.createElementText(bookmark, "name", b.getName());
        XMLUtil.createElementText(bookmark, "username", b.getUsername());
        XMLUtil.createElementText(bookmark, "password", b.getPassword());
        XMLUtil.createElementText(bookmark, "prompt", b.getPromptForPassword() ? "true" : "false");
        XMLUtil.createElementText(bookmark, "connect", b.getConnect());
        XMLUtil.createElementText(bookmark, "autoCommit", b.isAutoCommit() ? "true" : "false");
        XMLUtil.createElementText(bookmark, "autoCommitPreference", b.getAutoCommitPreference());
        XMLUtil.createElementText(bookmark, "autoCommitIgnoreView", b.isIgnoreQueryViewSetting() ? "true" : "false");
        XMLUtil.createElementText(bookmark, "quoteAll", b.isQuoteAll() ? "true" : "false");
        XMLUtil.createElementText(bookmark, "driver", b.getJDBCDriver().getClassName());
        XMLUtil.createElementText(bookmark, "type", b.getJDBCDriver().getType());
        String[] fileNames = b.getJDBCDriver().getJarFileNames();
        int i = 0;
        int length = fileNames == null ? 0 : fileNames.length;
        while (i < length) {
            XMLUtil.createElementText(bookmark, "driverLocation", fileNames[i]);
            ++i;
        }
        Element otherSchemas = (Element)bookmark.appendChild(document.createElement("Other_Schemas"));
        otherSchemas.setAttribute("schemaRule", b.useAllSchemas() ? "useAll" : (b.useUsernameAsSchema() ? "useDefault" : "useSelected"));
        Schema[] schemas = b.getSchemaSelections();
        int i2 = 0;
        int length2 = schemas == null ? 0 : schemas.length;
        while (i2 < length2) {
            XMLUtil.createElementText(otherSchemas, "schema", schemas[i2].getName());
            ++i2;
        }
        DatabaseObject[] quickList = b.getQuickListEntries();
        Element quickListEntity = document.createElement("quickList");
        int j = 0;
        int length3 = quickList == null ? 0 : quickList.length;
        while (j < length3) {
            ModelToXMLConverter.getInstance().convert(quickListEntity, quickList[j], false, false);
            ++j;
        }
        bookmark.appendChild(quickListEntity);
        this.convertQueryList(b, bookmark);
    }

    public void convert(Element parent, DatabaseObject object) {
        this.convert(parent, object, true, false);
    }

    public void convert(Element parent, DatabaseObject object, boolean isFull) {
        this.convert(parent, object, true, isFull);
    }

    public void convert(Element parent, DatabaseObject object, boolean recurse, boolean full) {
        Document document = parent.getOwnerDocument();
        Element element = document.createElement(this.getEntityDOMNodeName(object));
        element.setAttribute("name", object.getName());
        if (object.getSchema() != null) {
            element.setAttribute("schema", object.getSchema());
        }
        element.setAttribute("isSynonym", object.isSynonym() ? "true" : "false");
        element.setAttribute("database", object.getBookmark().getAdapter().getDisplayName());
        element.setAttribute("bookmark", object.getBookmark().getName());
        if (recurse) {
            if (object instanceof Sequence) {
                Sequence sequence = (Sequence)object;
                try {
                    element.setAttribute("minValue", sequence.getMinValue());
                    element.setAttribute("maxValue", sequence.getMaxValue());
                    element.setAttribute("initialValue", sequence.getInitialValue());
                    element.setAttribute("incrementBy", sequence.getIncrementBy());
                    element.setAttribute("cycled", sequence.isCycled() ? "true" : "false");
                    element.setAttribute("ordered", sequence.isOrdered() ? "true" : "false");
                }
                catch (NotConnectedException notConnectedException) {
                }
                catch (SQLException sQLException) {}
            } else if (object instanceof Table) {
                try {
                    Table table = (Table)object;
                    this.convert(element, table.getColumns());
                    if (full) {
                        this.convert(element, table.getExportedKeys(), true);
                        this.convert(element, table.getImportedKeys(), false);
                    }
                }
                catch (NotConnectedException notConnectedException) {
                }
                catch (SQLException sQLException) {}
            } else if (object instanceof View) {
                try {
                    View view = (View)object;
                    this.convert(element, view.getColumns());
                    if (view.getCreateStatement().length() > 0) {
                        XMLUtil.createCDATA(element, "createStatement", view.getCreateStatement());
                    }
                }
                catch (NotConnectedException notConnectedException) {
                }
                catch (SQLException sQLException) {}
            }
            if (recurse && full && object instanceof Entity) {
                this.convertTriggers(element, (Entity)object);
                this.convertChecks(element, (Entity)object);
                this.convertPrivileges(element, (Entity)object);
            }
            parent.appendChild(element);
        }
    }

    private void convertPrivileges(Element parent, Entity entity) {
        Privilege[] privileges = null;
        try {
            privileges = entity.getPrivileges();
        }
        catch (NotConnectedException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (privileges != null) {
            Document document = parent.getOwnerDocument();
            int i = 0;
            while (i < privileges.length) {
                Element element = document.createElement("privilege");
                Privilege privilege = privileges[i];
                element.setAttribute("grantor", privilege.getGrantor());
                element.setAttribute("grantee", privilege.getGrantee());
                element.setAttribute("access", privilege.getAccess());
                element.setAttribute("isGrantable", privilege.isGrantable() ? "true" : "false");
                parent.appendChild(element);
                ++i;
            }
        }
    }

    private void convert(Element parent, ForeignKey[] exportedKeys, boolean exported) {
        Document document = parent.getOwnerDocument();
        int i = 0;
        while (i < exportedKeys.length) {
            Element element = document.createElement("foreignKey");
            ForeignKey key = exportedKeys[i];
            element.setAttribute("type", exported ? "exported" : "imported");
            element.setAttribute("name", key.getName());
            element.setAttribute("localSchema", key.getLocalEntitySchema());
            element.setAttribute("localTable", key.getLocalEntityName());
            element.setAttribute("foreignSchema", key.getForeignEntitySchema());
            element.setAttribute("foreignTable", key.getForeignEntityName());
            element.setAttribute("onUpdate", ModelToXMLConverter.foreignKeyRuleToText(key.getUpdateRule()));
            element.setAttribute("onDelete", ModelToXMLConverter.foreignKeyRuleToText(key.getDeleteRule()));
            int j = 0;
            while (j < key.getNumberOfColumns()) {
                Element columnElement = document.createElement("joinedColumn");
                columnElement.setAttribute("position", String.valueOf(j + 1));
                columnElement.setAttribute("local", key.getLocalColumnName(j));
                columnElement.setAttribute("foreign", key.getForeignColumnName(j));
                element.appendChild(columnElement);
                ++j;
            }
            parent.appendChild(element);
            ++i;
        }
    }

    private static String foreignKeyRuleToText(int rule) {
        if (rule == 0) {
            return "cascade";
        }
        if (rule == 3) {
            return "noAction";
        }
        if (rule == 1) {
            return "restrict";
        }
        if (rule == 4) {
            return "setDefault";
        }
        if (rule == 2) {
            return "setNull";
        }
        return "";
    }

    private void convertTriggers(Element parent, Entity entity) {
        Trigger[] triggers = null;
        try {
            triggers = entity.getTriggers();
        }
        catch (NotConnectedException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (triggers != null) {
            Document document = parent.getOwnerDocument();
            int i = 0;
            while (i < triggers.length) {
                Element element = document.createElement("trigger");
                Trigger trigger = triggers[i];
                element.setAttribute("name", trigger.getName());
                element.setAttribute("moment", trigger.getMoment());
                element.setAttribute("forEach", trigger.getForEach());
                element.setAttribute("event", trigger.getEvent());
                element.setAttribute("columnName", trigger.getColumnName());
                element.setAttribute("language", trigger.getLanguage());
                element.setAttribute("referencing", trigger.getReferencing());
                if (trigger.getWhenClause() != null) {
                    XMLUtil.createCDATA(element, "whenClause", trigger.getWhenClause());
                }
                element.setAttribute("status", trigger.getStatus());
                element.setAttribute("actionType", trigger.getActionType());
                XMLUtil.createCDATA(element, "body", trigger.getBody());
                parent.appendChild(element);
                ++i;
            }
        }
    }

    private void convertChecks(Element parent, Entity entity) {
        Check[] checks = null;
        try {
            checks = entity.getChecks();
        }
        catch (NotConnectedException e) {
            e.printStackTrace();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        if (checks != null) {
            Document document = parent.getOwnerDocument();
            int i = 0;
            while (i < checks.length) {
                Element element = document.createElement("checkConstraint");
                Check check = checks[i];
                element.setAttribute("name", check.getName());
                XMLUtil.createCDATA(element, "body", check.getBody());
                parent.appendChild(element);
                ++i;
            }
        }
    }

    public void convert(Element element, Column[] columns) {
        int i = 0;
        int length = columns == null ? 0 : columns.length;
        while (i < length) {
            this.convert(element, columns[i]);
            ++i;
        }
    }

    public void convert(Element parent, Column column) {
        Document document = parent.getOwnerDocument();
        Element element = document.createElement("column");
        element.setAttribute("name", column.getName());
        element.setAttribute("type", column.getTypeName());
        element.setAttribute("java.sql.Types", String.valueOf(column.getType()));
        element.setAttribute("primaryKey", column.isPrimaryKey() ? "true" : "false");
        element.setAttribute("keyOrder", String.valueOf(column.getPrimaryKeyOrder()));
        element.setAttribute("nullable", column.isNullable() ? "true" : "false");
        element.setAttribute("position", String.valueOf(column.getPosition()));
        if (column.isNumeric()) {
            if (column.getSize() > 0L) {
                element.setAttribute("size", String.valueOf(column.getSize()));
            }
            if (column.getNumberOfFractionalDigits() > 0) {
                element.setAttribute("numberOfFractionalDigits", String.valueOf(column.getNumberOfFractionalDigits()));
            }
        } else if (column.getSize() > 0L) {
            element.setAttribute("size", String.valueOf(column.getSize()));
        }
        if (column.getDefaultValue() != null) {
            XMLUtil.createElementText(element, "defaultValue", column.getDefaultValue());
        }
        if (column.getRemarks().length() > 0) {
            XMLUtil.createElementText(element, "remarks", column.getRemarks());
        }
        parent.appendChild(element);
    }

    public String getEntityDOMNodeName(DatabaseObject object) {
        if ("TABLE".equals(object.getType())) {
            return "table";
        }
        if ("VIEW".equals(object.getType())) {
            return "view";
        }
        if ("SEQUENCE".equals(object.getType())) {
            return "sequence";
        }
        if ("PACKAGE".equals(object.getType())) {
            return "package";
        }
        return "unknown";
    }

    public void convertQueryList(Bookmark bookmark, Element parent) {
        Document document = parent.getOwnerDocument();
        String[] queryList = bookmark.getQueries();
        Element queryListEntity = document.createElement("queryList");
        int j = 0;
        int length = queryList == null ? 0 : queryList.length;
        while (j < length) {
            Element query = document.createElement("query");
            Element queryString = document.createElement("queryString");
            Text queryText = document.createTextNode(queryList[j]);
            queryString.appendChild(queryText);
            query.appendChild(queryString);
            queryListEntity.appendChild(query);
            ++j;
        }
        parent.appendChild(queryListEntity);
    }

    public Document convertList(List list, Document doc, boolean full) throws NotConnectedException, SQLException {
        if (doc == null) {
            try {
                doc = XMLHelper.createEmptyDocument();
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
                return null;
            }
            Element newRoot = (Element)doc.appendChild(doc.createElement(Messages.getString("ExportXMLAction.Metadata")));
            XMLUtil.createElementText(newRoot, Messages.getString("ExportXMLAction.Author"), Messages.getString("ExportXMLAction.Quantum"));
            XMLUtil.createElementText(newRoot, Messages.getString("ExportXMLAction.Version"), Messages.getString("ExportXMLAction.XMLVersionNumber"));
        }
        Element root = doc.getDocumentElement();
        Iterator iter = list.iterator();
        while (iter.hasNext()) {
            Object object = iter.next();
            if (object instanceof DbObjectNode) {
                ModelToXMLConverter.getInstance().convert(root, ((DbObjectNode)object).getDatabaseObject(), full);
                continue;
            }
            if (!(object instanceof GroupNode) && !(object instanceof SchemaNode) && !(object instanceof QuickListNode)) continue;
            TreeNode groupNode = (TreeNode)object;
            Object[] children = groupNode.getChildren();
            int i = 0;
            while (i < children.length) {
                if (children[i] instanceof DbObjectNode) {
                    ModelToXMLConverter.getInstance().convert(root, ((DbObjectNode)children[i]).getDatabaseObject(), full);
                } else if (children[i] instanceof GroupNode) {
                    this.convertList(Arrays.asList((GroupNode)children[i]), doc, full);
                }
                ++i;
            }
        }
        return doc;
    }
}

