/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.model;

import com.quantum.util.StringMatrix;
import java.util.Vector;

public class ObjectMetaData {
    private StringMatrix columns = new StringMatrix();
    private StringMatrix primaryKeys = new StringMatrix();
    private StringMatrix foreignKeys = new StringMatrix();
    private StringMatrix indexInfo = new StringMatrix();
    private StringMatrix bestRowId = new StringMatrix();

    public int getPrimaryKeyOrder(String column) {
        String index;
        if (this.primaryKeys.size() == 0) {
            return 0;
        }
        StringMatrix keyColumns = this.primaryKeys.select("COLUMN_NAME", column);
        if (keyColumns != null && keyColumns.size() > 0 && (index = keyColumns.get("KEY_SEQ", 0)) != null) {
            return Integer.parseInt(index);
        }
        return 0;
    }

    public int getColumnType(String column) {
        String type;
        StringMatrix selectCol = this.columns.select("COLUMN_NAME", column);
        if (selectCol != null && selectCol.size() > 0 && (type = selectCol.get("DATA_TYPE", 0)) != null) {
            return Integer.parseInt(type);
        }
        return 0;
    }

    public String getColumnsString() {
        String result = "";
        Vector columnNames = this.columns.getColumn("COLUMN_NAME");
        int i = 0;
        while (i < columnNames.size()) {
            if (i > 0) {
                result = String.valueOf(result) + ", ";
            }
            result = String.valueOf(result) + (String)columnNames.get(i);
            ++i;
        }
        return result;
    }

    public Vector getColumnNamesVector() {
        Vector result = new Vector();
        Vector columnNames = this.columns.getColumn("COLUMN_NAME");
        int i = 0;
        while (i < columnNames.size()) {
            result.add(columnNames.get(i));
            ++i;
        }
        return result;
    }

    public void setColumns(StringMatrix matrix) {
        this.columns = matrix;
    }

    public void setForeignKeys(StringMatrix matrix) {
        this.foreignKeys = matrix;
    }

    public void setPrimaryKeys(StringMatrix matrix) {
        this.primaryKeys = matrix;
    }

    public void setBestRowId(StringMatrix matrix) {
        this.bestRowId = matrix;
    }

    public void setIndexInfo(StringMatrix matrix) {
        this.indexInfo = matrix;
    }

    public StringMatrix getColumns() {
        return this.columns;
    }

    public StringMatrix getForeignKeys() {
        return this.foreignKeys;
    }

    public StringMatrix getPrimaryKeys() {
        return this.primaryKeys;
    }

    public StringMatrix getIndexInfo() {
        return this.indexInfo;
    }

    public StringMatrix getBestRowId() {
        return this.bestRowId;
    }

    public void dropColumn(String columnName) {
        this.columns.dropMatching("COLUMN_NAME", columnName);
    }

    public Object clone() {
        ObjectMetaData result = new ObjectMetaData();
        result.columns = (StringMatrix)this.columns.clone();
        result.primaryKeys = (StringMatrix)this.primaryKeys.clone();
        result.indexInfo = (StringMatrix)this.indexInfo.clone();
        result.foreignKeys = (StringMatrix)this.foreignKeys.clone();
        return result;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ObjectMetaData)) {
            return false;
        }
        ObjectMetaData obMd = (ObjectMetaData)obj;
        return this.columns.equals(obMd.columns) && this.primaryKeys.equals(obMd.primaryKeys) && this.indexInfo.equals(obMd.indexInfo) && this.foreignKeys.equals(obMd.foreignKeys);
    }

    public String toString() {
        return String.valueOf(this.columns.toString()) + this.foreignKeys.toString() + this.indexInfo.toString() + this.primaryKeys.toString();
    }

    public String getQualifiedTableName() {
        if (this.columns.size() < 1) {
            return "";
        }
        String result = this.columns.get("TABLE_NAME", 0);
        String schema = this.columns.get("TABLE_SCHEM", 0);
        if (schema != null && schema.length() > 0) {
            result = String.valueOf(schema) + "." + result;
        }
        return result;
    }
}

