/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.model;

import com.quantum.model.Bookmark;
import com.quantum.model.DatabaseObject;
import com.quantum.model.Entity;
import com.quantum.model.PackageImpl;
import com.quantum.model.SequenceImpl;
import com.quantum.model.TableImpl;
import com.quantum.model.ViewImpl;

public class DatabaseObjectFactory {
    private static DatabaseObjectFactory instance = new DatabaseObjectFactory();

    private DatabaseObjectFactory() {
    }

    public static DatabaseObjectFactory getInstance() {
        return instance;
    }

    public DatabaseObject create(Bookmark bookmark, String schema, String name, String type, boolean isSynonym) {
        return this.createObject(bookmark, schema, name, type, isSynonym);
    }

    public DatabaseObject createObject(Bookmark bookmark, String schema, String name, String type, boolean isSynonym) {
        if (type == null) {
            return null;
        }
        if ("PACKAGE".equals(type = type.toUpperCase().trim())) {
            return new PackageImpl(bookmark, schema, name);
        }
        return this.createEntity(bookmark, schema, name, type, isSynonym);
    }

    public Entity createEntity(Bookmark bookmark, String schema, String name, String type, boolean isSynonym) {
        if (type == null) {
            return null;
        }
        if ("TABLE".equals(type = type.toUpperCase().trim())) {
            return new TableImpl(bookmark, schema, name, isSynonym);
        }
        if ("VIEW".equals(type)) {
            return new ViewImpl(bookmark, schema, name, isSynonym);
        }
        if ("SEQUENCE".equals(type)) {
            return new SequenceImpl(bookmark, schema, name, isSynonym);
        }
        return null;
    }
}

