/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.model;

import com.quantum.QuantumPlugin;
import com.quantum.adapters.DatabaseAdapter;
import com.quantum.model.Bookmark;
import com.quantum.model.DataType;
import com.quantum.model.DatabaseObject;
import com.quantum.model.DatabaseObjectFactory;
import com.quantum.model.Entity;
import com.quantum.model.ForeignKey;
import com.quantum.model.ForeignKeyImpl;
import com.quantum.model.Schema;
import com.quantum.sql.MultiSQLServer;
import com.quantum.sql.SQLResultSetResults;
import com.quantum.util.connection.Connectable;
import com.quantum.util.connection.NotConnectedException;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.eclipse.jface.preference.IPreferenceStore;

public class Database {
    private DatabaseAdapter databaseAdapter;
    private Bookmark bookmark;
    private List entityTypes;
    private static final String[] ALL_TABLE_TYPES = new String[]{"ALIAS", "TABLE", "VIEW", "SEQUENCE"};
    private static final List STANDARD_TABLE_TYPES = Collections.synchronizedList(new ArrayList());

    static {
        int i = 0;
        int length = ALL_TABLE_TYPES == null ? 0 : ALL_TABLE_TYPES.length;
        while (i < length) {
            STANDARD_TABLE_TYPES.add(ALL_TABLE_TYPES[i]);
            ++i;
        }
    }

    public Database(Bookmark bookmark) {
        this.bookmark = bookmark;
        this.databaseAdapter = bookmark.getAdapter();
    }

    public synchronized String[] getEntityTypes() throws NotConnectedException, SQLException {
        if (this.entityTypes == null) {
            Set collection = this.initializeObjectTypes(this.bookmark.getConnection());
            this.entityTypes = Collections.synchronizedList(new ArrayList(collection));
        }
        return this.entityTypes.toArray(new String[this.entityTypes.size()]);
    }

    public String getUsername() throws NotConnectedException, SQLException {
        return this.getMetaData().getUserName();
    }

    private Set initializeObjectTypes(Connection connection) throws SQLException {
        HashSet<String> set = new HashSet<String>();
        if (this.databaseAdapter.getShowTableQuery(this.bookmark.getUsername()) != null) {
            set.add("TABLE");
        }
        if (this.databaseAdapter.getShowViewQuery(this.bookmark.getUsername()) != null) {
            set.add("VIEW");
        }
        if (this.databaseAdapter.getShowSequenceQuery(this.bookmark.getUsername()) != null) {
            set.add("SEQUENCE");
        }
        if (this.databaseAdapter.getShowPackagesQuery(this.bookmark.getUsername()) != null) {
            set.add("PACKAGE");
        }
        DatabaseMetaData metaData = connection.getMetaData();
        ResultSet resultSet = metaData.getTableTypes();
        while (resultSet.next()) {
            String type = resultSet.getString(1);
            if (type != null) {
                type = type.trim();
            }
            if (!STANDARD_TABLE_TYPES.contains(type)) continue;
            set.add(type);
        }
        return set;
    }

    public String getInformation() throws SQLException {
        try {
            DatabaseMetaData metaData = this.getMetaData();
            return metaData == null ? null : String.valueOf(metaData.getDatabaseProductName()) + " " + metaData.getDatabaseProductVersion();
        }
        catch (NotConnectedException notConnectedException) {
            return "";
        }
    }

    public String getDatabaseName() throws SQLException {
        try {
            DatabaseMetaData metaData = this.getMetaData();
            return metaData == null ? null : metaData.getDatabaseProductName();
        }
        catch (NotConnectedException notConnectedException) {
            return "";
        }
    }

    public int getDatabaseMajorVersion() throws SQLException {
        try {
            DatabaseMetaData metaData = this.getMetaData();
            return metaData == null ? 0 : metaData.getDatabaseMajorVersion();
        }
        catch (NotConnectedException notConnectedException) {
            return 0;
        }
    }

    public DatabaseObject[] getObjects(Bookmark bookmark, Schema schema, String type) throws SQLException, NotConnectedException {
        return this.getObjects(bookmark, schema, type, null);
    }

    public DatabaseObject[] getObjects(Bookmark bookmark, Schema schema, String type, String prefix) throws SQLException, NotConnectedException {
        Connection connection = bookmark.getConnection();
        DatabaseObject[] result = this.getObjects(bookmark, connection, schema, type, prefix);
        return result == null ? new Entity[]{} : result;
    }

    protected DatabaseObject[] getObjects(Bookmark bookmark, Connection connection, Schema schema, String type, String prefix) throws SQLException {
        String[] stringArray;
        ArrayList list = new ArrayList();
        if (type == null) {
            stringArray = ALL_TABLE_TYPES;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = type;
        }
        String[] types = stringArray;
        IPreferenceStore store = QuantumPlugin.getDefault().getPreferenceStore();
        int i = 0;
        while (i < types.length) {
            list.addAll(this.getObjectsList(bookmark, connection, types[i], schema, prefix));
            if (store.getBoolean("getSynonyms")) {
                list.addAll(this.getSynonymsList(bookmark, connection, types[i], schema));
            }
            ++i;
        }
        return list.toArray(new DatabaseObject[list.size()]);
    }

    protected List getObjectsList(Bookmark bookmark, Connection connection, String type, Schema schema, String prefix) throws SQLException {
        String regexp;
        ArrayList<DatabaseObject> list = new ArrayList<DatabaseObject>();
        DatabaseMetaData metaData = connection.getMetaData();
        ResultSet set = null;
        String string = regexp = prefix != null ? String.valueOf(prefix) + "%" : "%";
        set = metaData.supportsSchemasInTableDefinitions() ? metaData.getTables(null, schema != null ? schema.getName() : null, regexp, new String[]{type}) : metaData.getTables(null, null, "%", new String[]{type});
        while (set.next()) {
            DatabaseObject object;
            String tempSchema = set.getString(2);
            tempSchema = tempSchema == null ? "" : tempSchema.trim();
            String tableName = set.getString(3);
            String string2 = tableName = tableName == null ? "" : tableName.trim();
            if (tableName == null || tableName.length() <= 0 || (object = DatabaseObjectFactory.getInstance().create(bookmark, tempSchema, tableName, type, false)) == null) continue;
            list.add(object);
        }
        set.close();
        if (list.size() > 0) {
            return list;
        }
        SQLResultSetResults results = null;
        String sql = this.getSQL(bookmark, type, schema);
        if (sql != null) {
            results = (SQLResultSetResults)MultiSQLServer.getInstance().execute((Connectable)bookmark, connection, sql, Integer.MAX_VALUE);
            int i = 1;
            int size = results == null ? 0 : results.getRowCount();
            while (i <= size) {
                DatabaseObject object;
                String tableName;
                String schemaName;
                String string3 = schemaName = results.getColumnCount() == 1 ? schema.getName() : results.getElement(1, i).toString();
                if (schemaName != null) {
                    schemaName = schemaName.trim();
                }
                String string4 = tableName = results.getColumnCount() == 1 ? results.getElement(1, i).toString() : results.getElement(2, i).toString();
                if (tableName != null && tableName.length() > 0 && (object = DatabaseObjectFactory.getInstance().create(bookmark, schemaName, tableName, type, false)) != null) {
                    list.add(object);
                }
                ++i;
            }
        }
        return list;
    }

    protected List getPackages(Bookmark bookmark, Connection connection, Schema schema) throws SQLException {
        ArrayList<DatabaseObject> list = new ArrayList<DatabaseObject>();
        SQLResultSetResults results = null;
        String sql = this.getSQL(bookmark, "PACKAGE", schema);
        if (sql != null) {
            results = (SQLResultSetResults)MultiSQLServer.getInstance().execute((Connectable)bookmark, connection, sql, Integer.MAX_VALUE);
            int i = 1;
            int size = results == null ? 0 : results.getRowCount();
            while (i <= size) {
                DatabaseObject object;
                String packageName;
                String schemaName;
                String string = schemaName = results.getColumnCount() == 1 ? schema.getName() : results.getElement(1, i).toString();
                if (schemaName != null) {
                    schemaName = schemaName.trim();
                }
                String string2 = packageName = results.getColumnCount() == 1 ? results.getElement(1, i).toString() : results.getElement(2, i).toString();
                if (packageName != null && packageName.length() > 0 && (object = DatabaseObjectFactory.getInstance().create(bookmark, schemaName, packageName, "PACKAGE", false)) != null) {
                    list.add(object);
                }
                ++i;
            }
        }
        return list;
    }

    protected List getSynonymsList(Bookmark bookmark, Connection connection, String type, Schema schema) throws SQLException {
        ArrayList<Entity> list = new ArrayList<Entity>();
        SQLResultSetResults results = null;
        String sql = this.databaseAdapter.getShowSynonymsQuery(schema.getName(), type);
        if (sql != null) {
            results = (SQLResultSetResults)MultiSQLServer.getInstance().execute((Connectable)bookmark, connection, sql, Integer.MAX_VALUE);
            int i = 1;
            int size = results == null ? 0 : results.getRowCount();
            while (i <= size) {
                Entity entity;
                String tableName;
                String schemaName;
                String string = schemaName = results.getColumnCount() == 1 ? schema.getName() : results.getElement(1, i).toString();
                if (schemaName != null) {
                    schemaName = schemaName.trim();
                }
                String string2 = tableName = results.getColumnCount() == 1 ? results.getElement(1, i).toString() : results.getElement(2, i).toString();
                if (tableName != null && tableName.length() > 0 && (entity = DatabaseObjectFactory.getInstance().createEntity(bookmark, schemaName, tableName, type, true)) != null) {
                    list.add(entity);
                }
                ++i;
            }
        }
        return list;
    }

    /*
     * Exception decompiling
     */
    public DataType[] getTypes() throws NotConnectedException, SQLException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Back jump on a try block [egrp 1[TRYBLOCK] [1 : 116->119)] java.lang.Throwable
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op02WithProcessedDataAndRefs.insertExceptionBlocks(Op02WithProcessedDataAndRefs.java:2283)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:415)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    public DatabaseMetaData getMetaData() throws NotConnectedException, SQLException {
        Connection connection = this.bookmark.getConnection();
        DatabaseMetaData metaData = connection.getMetaData();
        return metaData;
    }

    private String getSQL(Bookmark bookmark, String type, Schema schema) {
        String name = schema.getName();
        if ("TABLE".equals(type)) {
            return this.databaseAdapter.getShowTableQuery(name);
        }
        if ("ALIAS".equals(type)) {
            return this.databaseAdapter.getShowAliasQuery(name);
        }
        if ("VIEW".equals(type)) {
            return this.databaseAdapter.getShowViewQuery(name);
        }
        if ("SEQUENCE".equals(type)) {
            return this.databaseAdapter.getShowSequenceQuery(name);
        }
        if ("PACKAGE".equals(type)) {
            return this.databaseAdapter.getShowPackagesQuery(name);
        }
        return null;
    }

    public ForeignKey[] getExportedKeys(String schema, String entityName) throws NotConnectedException, SQLException {
        DatabaseMetaData metaData = this.getMetaData();
        ArrayList list = new ArrayList();
        return this.getForeignKeys(list, metaData.getExportedKeys(null, schema, entityName));
    }

    public ForeignKey[] getImportedKeys(String schema, String entityName) throws NotConnectedException, SQLException {
        DatabaseMetaData metaData = this.getMetaData();
        ArrayList list = new ArrayList();
        return this.getForeignKeys(list, metaData.getImportedKeys(null, schema, entityName));
    }

    private ForeignKey[] getForeignKeys(List list, ResultSet resultSet) throws SQLException {
        ForeignKey[] foreignKeyArray;
        ForeignKeyImpl foreignKey = null;
        int lowestKeySequence = Integer.MAX_VALUE;
        try {
            while (resultSet.next()) {
                int keySequence = resultSet.getInt(9);
                if (keySequence == (lowestKeySequence = Math.min(lowestKeySequence, keySequence)) || foreignKey == null) {
                    foreignKey = new ForeignKeyImpl();
                    list.add(foreignKey);
                    foreignKey.setName(resultSet.getString(12));
                    foreignKey.setUpdateRule(resultSet.getShort(10));
                    foreignKey.setDeleteRule(resultSet.getShort(11));
                    foreignKey.setForeignEntitySchema(resultSet.getString(6));
                    foreignKey.setForeignEntityName(resultSet.getString(7));
                    foreignKey.setLocalEntitySchema(resultSet.getString(2));
                    foreignKey.setLocalEntityName(resultSet.getString(3));
                }
                foreignKey.addColumns(resultSet.getString(4), resultSet.getString(8));
            }
            foreignKeyArray = list.toArray(new ForeignKey[list.size()]);
            Object var6_7 = null;
        }
        catch (Throwable throwable) {
            Object var6_8 = null;
            resultSet.close();
            throw throwable;
        }
        resultSet.close();
        return foreignKeyArray;
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public Schema[] getSchemas() throws NotConnectedException, SQLException {
        ArrayList<Schema> list = new ArrayList<Schema>();
        if (!this.supportsSchemasInTableDefinitions()) return list.toArray(new Schema[list.size()]);
        ResultSet resultSet = this.getMetaData().getSchemas();
        try {
            while (resultSet.next()) {
                String schemaName = resultSet.getString(1);
                list.add(new Schema(schemaName));
            }
        }
        catch (Throwable throwable) {
            Object var4_5 = null;
            resultSet.close();
            throw throwable;
        }
        {
            Object var4_6 = null;
        }
        resultSet.close();
        return list.toArray(new Schema[list.size()]);
    }

    public boolean supportsSchemasInTableDefinitions() throws NotConnectedException, SQLException {
        return this.getMetaData().supportsSchemasInTableDefinitions();
    }
}

