/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.log;

import com.quantum.QuantumPlugin;
import com.quantum.log.LogEntry;
import com.quantum.log.Severity;
import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;

public class QuantumLog {
    public static final String NUMBER_OF_ENTRIES_PREFERENCE_NAME;
    public static final String LOG_LEVEL_PREFERENCE_NAME;
    private static final QuantumLog instance;
    private IPropertyChangeListener listener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            if (NUMBER_OF_ENTRIES_PREFERENCE_NAME.equals(event.getProperty())) {
                QuantumLog.this.setNumberOfEntriesFromPreferences();
            } else if (LOG_LEVEL_PREFERENCE_NAME.equals(event.getProperty())) {
                QuantumLog.this.setLogLevelFromPreferences();
            }
        }
    };
    private List log = Collections.synchronizedList(new ArrayList());
    private int numberOfEntries = 300;
    private Severity logLevel = Severity.INFO;
    private PropertyChangeSupport propertyChangeSupport = new PropertyChangeSupport(this);
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.quantum.log.QuantumLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        NUMBER_OF_ENTRIES_PREFERENCE_NAME = String.valueOf(clazz.getName()) + ".numberOfEntries";
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("com.quantum.log.QuantumLog");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        LOG_LEVEL_PREFERENCE_NAME = String.valueOf(clazz2.getName()) + ".logLevel";
        instance = new QuantumLog();
    }

    private QuantumLog() {
        this.setLogLevelFromPreferences();
        this.setNumberOfEntriesFromPreferences();
        QuantumPlugin.getDefault().getPreferenceStore().addPropertyChangeListener(this.listener);
    }

    public static QuantumLog getInstance() {
        return instance;
    }

    public void info(String message) {
        this.addToLog(Severity.INFO, message);
    }

    private void addToLog(Severity severity, String message) {
        this.addToLog(severity, message, null);
    }

    private void addToLog(Severity severity, String message, Throwable throwable) {
        if (severity.getRank() >= this.logLevel.getRank()) {
            LogEntry logEntry = new LogEntry(severity, message, this.getStackTraceAsString(throwable));
            this.log.add(logEntry);
            this.trimLog();
            this.propertyChangeSupport.firePropertyChange("entries", null, logEntry);
        }
    }

    private String getStackTraceAsString(Throwable throwable) {
        if (throwable != null) {
            StringWriter writer = new StringWriter();
            PrintWriter printWriter = new PrintWriter(writer);
            throwable.printStackTrace(printWriter);
            printWriter.close();
            return writer.toString();
        }
        return null;
    }

    private void trimLog() {
        while (this.log.size() > this.numberOfEntries && !this.log.isEmpty()) {
            this.log.remove(0);
        }
    }

    public void debug(String message) {
        this.addToLog(Severity.DEBUG, message);
    }

    public void error(String message) {
        this.addToLog(Severity.ERROR, message);
    }

    public void error(String message, Throwable throwable) {
        this.addToLog(Severity.ERROR, message, throwable);
    }

    public void warn(String message) {
        this.addToLog(Severity.WARN, message);
    }

    private void setNumberOfEntriesFromPreferences() {
        IPreferenceStore store = QuantumPlugin.getDefault().getPreferenceStore();
        int temp = store.getInt(NUMBER_OF_ENTRIES_PREFERENCE_NAME);
        if (temp > 0) {
            this.numberOfEntries = temp;
        }
    }

    private void setLogLevelFromPreferences() {
        IPreferenceStore store = QuantumPlugin.getDefault().getPreferenceStore();
        String level = store.getString(LOG_LEVEL_PREFERENCE_NAME);
        this.logLevel = Severity.getSeverity(level);
    }

    public LogEntry[] getEntries() {
        return this.log.toArray(new LogEntry[this.log.size()]);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertyChangeSupport.removePropertyChangeListener(listener);
    }

    public void clear() {
        this.log.clear();
        this.propertyChangeSupport.firePropertyChange("entries", null, null);
    }

    public int getNumberOfEntries() {
        return this.numberOfEntries;
    }
}

