/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.editors;

import com.quantum.editors.PredicateRuleAdapter;
import com.quantum.editors.SQLNumberRule;
import com.quantum.editors.SQLSeparatorRule;
import com.quantum.editors.SQLWordRule;
import com.quantum.editors.SymbolRule;
import com.quantum.editors.WhitespaceDetector;
import com.quantum.util.sql.SQLGrammar;
import java.util.ArrayList;
import org.eclipse.jface.text.rules.EndOfLineRule;
import org.eclipse.jface.text.rules.IPredicateRule;
import org.eclipse.jface.text.rules.IRule;
import org.eclipse.jface.text.rules.IToken;
import org.eclipse.jface.text.rules.IWhitespaceDetector;
import org.eclipse.jface.text.rules.MultiLineRule;
import org.eclipse.jface.text.rules.RuleBasedPartitionScanner;
import org.eclipse.jface.text.rules.SingleLineRule;
import org.eclipse.jface.text.rules.Token;
import org.eclipse.jface.text.rules.WhitespaceRule;

public class SQLPartitionScanner
extends RuleBasedPartitionScanner {
    public SQLPartitionScanner() {
        ArrayList<PredicateRuleAdapter> rules = new ArrayList<PredicateRuleAdapter>();
        Token comment = new Token((Object)"__sql_comment");
        Token string = new Token((Object)"__sql_string");
        Token identifier = new Token((Object)"__sql_word");
        Token keyword = new Token((Object)"__sql_keyword");
        Token separator = new Token((Object)"__sql_separator");
        Token symbol = new Token((Object)"__sql_symbol");
        Token whitespace = new Token((Object)"__dftl_partition_content_type");
        Token numeric = new Token((Object)"__sql_numeric");
        rules.add(new PredicateRuleAdapter((IRule)new WhitespaceRule((IWhitespaceDetector)new WhitespaceDetector()), (IToken)whitespace));
        rules.add((PredicateRuleAdapter)new MultiLineRule("/*", "*/", (IToken)comment));
        rules.add((PredicateRuleAdapter)new EndOfLineRule("--", (IToken)comment));
        rules.add((PredicateRuleAdapter)new SingleLineRule("'", "'", (IToken)string));
        rules.add(new PredicateRuleAdapter(new SQLNumberRule((IToken)numeric), (IToken)numeric));
        SQLWordRule wordRule = new SQLWordRule((IToken)identifier);
        int i = 0;
        while (i < SQLGrammar.KEYWORDS.length) {
            wordRule.addKeyword(SQLGrammar.KEYWORDS[i], (IToken)keyword);
            ++i;
        }
        rules.add(new PredicateRuleAdapter(wordRule, (IToken)keyword));
        rules.add(new PredicateRuleAdapter(wordRule, (IToken)identifier));
        rules.add(new PredicateRuleAdapter(new SQLSeparatorRule((IToken)separator), (IToken)separator));
        rules.add(new PredicateRuleAdapter(new SymbolRule((IToken)symbol), (IToken)symbol));
        IPredicateRule[] result = new IPredicateRule[rules.size()];
        rules.toArray(result);
        this.setPredicateRules(result);
    }
}

