/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.editors;

import com.quantum.ImageStore;
import com.quantum.editors.SQLDocumentProvider;
import com.quantum.editors.SQLEditor;
import com.quantum.sql.parser.SQLParser;
import java.util.StringTokenizer;
import java.util.Vector;
import org.eclipse.jface.text.DocumentEvent;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IDocumentListener;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.jface.viewers.ILabelProviderListener;
import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.TreeViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.views.contentoutline.ContentOutlinePage;

public class SQLContentOutlinePage
extends ContentOutlinePage {
    private IDocumentListener listener;
    private final SQLDocumentProvider documentProvider;
    private IEditorInput editorInput;

    public SQLContentOutlinePage(SQLDocumentProvider documentProvider, SQLEditor editor) {
        this.documentProvider = documentProvider;
    }

    public void createControl(Composite parent) {
        super.createControl(parent);
        final TreeViewer treeViewer = this.getTreeViewer();
        IDocument document = this.documentProvider.getDocument(this.editorInput);
        if (document != null) {
            treeViewer.setLabelProvider((IBaseLabelProvider)new LabelProviderImpl());
            treeViewer.setContentProvider((IContentProvider)new ContentProviderImpl());
            treeViewer.setInput((Object)document);
            this.listener = new IDocumentListener(){

                public void documentAboutToBeChanged(DocumentEvent event) {
                }

                public void documentChanged(DocumentEvent event) {
                    treeViewer.refresh();
                }
            };
            document.addDocumentListener(this.listener);
        }
    }

    public void setInput(IEditorInput editorInput) {
        this.editorInput = editorInput;
    }

    public void dispose() {
        IDocument document;
        if (this.listener != null && (document = this.documentProvider.getDocument(this.editorInput)) != null) {
            document.removeDocumentListener(this.listener);
            this.listener = null;
        }
        super.dispose();
    }

    class LabelProviderImpl
    implements ILabelProvider {
        LabelProviderImpl() {
        }

        public Image getImage(Object element) {
            return ImageStore.getImage("script");
        }

        public String getText(Object element) {
            if (element != null && element instanceof String) {
                String token;
                StringTokenizer tokenizer = new StringTokenizer((String)element);
                String string = token = tokenizer.hasMoreTokens() ? tokenizer.nextToken() : "";
                if ("select".equalsIgnoreCase(token) || "update".equalsIgnoreCase(token) || "insert".equalsIgnoreCase(token) || "delete".equalsIgnoreCase(token) || "grant".equalsIgnoreCase(token)) {
                    return token;
                }
                if (tokenizer.hasMoreTokens()) {
                    return String.valueOf(token) + " " + tokenizer.nextToken();
                }
                return token;
            }
            return element == null ? "" : element.toString();
        }

        public void addListener(ILabelProviderListener listener) {
        }

        public void dispose() {
        }

        public boolean isLabelProperty(Object element, String property) {
            return false;
        }

        public void removeListener(ILabelProviderListener listener) {
        }
    }

    class ContentProviderImpl
    implements ITreeContentProvider {
        ContentProviderImpl() {
        }

        public Object[] getElements(Object inputElement) {
            if (inputElement != null && inputElement instanceof IDocument) {
                String text = ((IDocument)inputElement).get();
                Vector sql = SQLParser.parse(text);
                return sql.toArray();
            }
            return null;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }

        public Object[] getChildren(Object parentElement) {
            return null;
        }

        public Object getParent(Object element) {
            return null;
        }

        public boolean hasChildren(Object element) {
            return false;
        }
    }
}

