/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.editors;

import com.quantum.ImageStore;
import com.quantum.editors.PartitionTypes;
import com.quantum.util.StringUtil;
import com.quantum.util.sql.SQLGrammar;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.eclipse.jface.text.BadLocationException;
import org.eclipse.jface.text.IDocument;
import org.eclipse.jface.text.IRegion;
import org.eclipse.jface.text.ITextViewer;
import org.eclipse.jface.text.ITypedRegion;
import org.eclipse.jface.text.Region;
import org.eclipse.jface.text.contentassist.CompletionProposal;
import org.eclipse.jface.text.contentassist.ICompletionProposal;
import org.eclipse.jface.text.contentassist.IContentAssistProcessor;
import org.eclipse.jface.text.contentassist.IContextInformation;
import org.eclipse.jface.text.contentassist.IContextInformationValidator;
import org.eclipse.jface.text.templates.DocumentTemplateContext;
import org.eclipse.jface.text.templates.Template;
import org.eclipse.jface.text.templates.TemplateContext;
import org.eclipse.jface.text.templates.TemplateContextType;
import org.eclipse.jface.text.templates.TemplateProposal;

public class SQLContentAssistProcessor
implements IContentAssistProcessor {
    private List templates = Collections.synchronizedList(new ArrayList());
    private String contentType;

    public SQLContentAssistProcessor(String contentType) {
        this.contentType = contentType;
        this.templates.add(new Template("select", "select columns from a table or view", "", "select *\n  from ${schema}.${table}\n  where ${expression};"));
        this.templates.add(new Template("insert", "insert a row into a table", "", "insert into ${schema}.${table} (${column1}, ${column2}) values (${value1}, ${value2});"));
        this.templates.add(new Template("delete", "delete rows from a table", "", "delete from ${schema}.${table} where ${expression};"));
    }

    public ICompletionProposal[] computeCompletionProposals(ITextViewer viewer, int offset) {
        PartitionText text = this.getCurrentPartitionText(viewer.getDocument(), offset, offset);
        Region region = text == null ? new Region(offset, 0) : new Region(text.getStart(), offset - text.getStart());
        ArrayList proposals = new ArrayList();
        this.addTemplateProposals(viewer, text, region, proposals);
        this.addKeywordProposals(text, region, proposals);
        return proposals.toArray(new ICompletionProposal[proposals.size()]);
    }

    private void addKeywordProposals(PartitionText text, Region region, List proposals) {
        int i = 0;
        int length = SQLGrammar.KEYWORDS == null ? 0 : SQLGrammar.KEYWORDS.length;
        while (i < length) {
            if (text == null) {
                proposals.add(new CompletionProposal(SQLGrammar.KEYWORDS[i], region.getOffset(), region.getLength(), region.getOffset() + region.getLength()));
            } else if (StringUtil.startsWithIgnoreCase(SQLGrammar.KEYWORDS[i], text.getText())) {
                proposals.add(new CompletionProposal(SQLGrammar.KEYWORDS[i], region.getOffset(), region.getLength(), region.getOffset() + region.getLength()));
            }
            ++i;
        }
    }

    private void addTemplateProposals(ITextViewer viewer, PartitionText text, Region region, List proposals) {
        Iterator i = this.templates.iterator();
        while (i.hasNext()) {
            Template template = (Template)i.next();
            if (text == null) {
                proposals.add(this.createProposal(viewer, region, template));
                continue;
            }
            if (!template.getName().startsWith(text.getText())) continue;
            proposals.add(this.createProposal(viewer, region, template));
        }
    }

    private PartitionText getCurrentPartitionText(IDocument document, int offset, int to) {
        try {
            if (offset > 0) {
                ITypedRegion region = document.getPartition(offset - 1);
                if ("__sql_word".equals(region.getType()) || "__sql_keyword".equals(region.getType())) {
                    return new PartitionText(region, document.get(region.getOffset(), offset - region.getOffset()));
                }
                if (PartitionTypes.isSQLPartition(region)) {
                    return null;
                }
                String string = document.get(region.getOffset(), offset - region.getOffset());
                return StringUtil.isNotEmpty(string) ? new PartitionText(region.getOffset(), string) : null;
            }
            return null;
        }
        catch (BadLocationException badLocationException) {
            return null;
        }
    }

    private ICompletionProposal createProposal(ITextViewer viewer, Region region, Template template) {
        DocumentTemplateContext context = new DocumentTemplateContext(new TemplateContextType("com.quantum.sql.templates"), viewer.getDocument(), region.getOffset(), region.getLength());
        TemplateProposal proposal = new TemplateProposal(template, (TemplateContext)context, (IRegion)region, ImageStore.getImage("template"));
        return proposal;
    }

    public IContextInformation[] computeContextInformation(ITextViewer viewer, int offset) {
        return null;
    }

    public char[] getCompletionProposalAutoActivationCharacters() {
        return new char[]{' '};
    }

    public char[] getContextInformationAutoActivationCharacters() {
        return null;
    }

    public String getErrorMessage() {
        return null;
    }

    public IContextInformationValidator getContextInformationValidator() {
        return null;
    }

    private class PartitionText {
        private final String text;
        private final int start;

        PartitionText(ITypedRegion region, String text) {
            this.start = region.getOffset();
            this.text = text;
        }

        public PartitionText(int start, String text) {
            this.start = start;
            this.text = text;
        }

        public String getText() {
            return this.text == null ? null : this.text.trim();
        }

        public int getStart() {
            return this.text == null ? this.start : this.start + this.text.indexOf(this.getText());
        }
    }
}

