/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.adapters;

import com.quantum.adapters.DatabaseAdapter;
import com.quantum.util.sql.TypesHelper;
import java.util.HashMap;
import java.util.Map;

public class PostgresAdapter
extends DatabaseAdapter {
    protected PostgresAdapter() {
        super("POSTGRES");
    }

    public String getShowTableQuery(String qualifier) {
        return "SELECT SCHEMANAME, TABLENAME FROM PG_TABLES WHERE SCHEMANAME = '" + qualifier + "'";
    }

    public String getShowViewQuery(String qualifier) {
        return "SELECT SCHEMANAME, VIEWNAME FROM PG_VIEWS WHERE SCHEMANAME = '" + qualifier + "'";
    }

    public String getShowSequenceQuery(String qualifier) {
        return "select pg_namespace.nspname, relname from pg_class, pg_namespace where relkind = 'S' and relnamespace = pg_namespace.oid and pg_namespace.nspname = '" + qualifier + "'";
    }

    public String getNextValue(String sequence, String owner) {
        return "SELECT NEXTVAL('" + this.getQualifiedName(owner, sequence) + "')";
    }

    public String getPrevValue(String sequence, String owner) {
        return "SELECT * FROM " + this.getQualifiedName(owner, sequence);
    }

    public String quote(String string, int type, String typeString) {
        if (type == -7 || type == TypesHelper.BOOLEAN) {
            if (string.indexOf(116) >= 0 || string.indexOf(84) >= 0) {
                return "true";
            }
            if (string.indexOf(102) >= 0 || string.indexOf(70) >= 0) {
                return "false";
            }
            return string;
        }
        return super.quote(string, type, typeString);
    }

    public String getDefaultSchema(String userid) {
        return "public";
    }

    public Map getDefaultConnectionParameters() {
        HashMap<String, String> map = new HashMap<String, String>();
        map.put("port", "5432");
        map.put("hostname", "localhost");
        return map;
    }

    public String getCreateStatement(String schema, String viewName) {
        return "select view_definition from information_schema.views where table_schema = '" + schema + "' " + "and table_name = '" + viewName + "'";
    }
}

