/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.adapters;

import com.quantum.adapters.StatementExplainer;
import com.quantum.sql.MultiSQLServer;
import com.quantum.sql.SQLResultSetResults;
import com.quantum.sql.parser.SQL;
import com.quantum.util.connection.Connectable;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Random;

public class DB2StatementExplainer
implements StatementExplainer {
    private Random random = new Random();

    public boolean isExplainable(SQL sqlStatement) {
        return true;
    }

    public SQLResultSetResults explain(Connectable connectable, Connection connection, SQL sqlStatement) throws SQLException {
        int queryNumber = this.getRandomQueryNumber();
        MultiSQLServer.getInstance().execute(connectable, connection, this.createExplainStatement(sqlStatement, queryNumber), Integer.MAX_VALUE);
        return (SQLResultSetResults)MultiSQLServer.getInstance().execute(connectable, connection, this.getPlanStatement(queryNumber), Integer.MAX_VALUE);
    }

    protected String createExplainStatement(SQL sqlStatement, int queryNumber) {
        String explainStatement = "EXPLAIN PLAN SET queryno = " + queryNumber + " FOR (" + sqlStatement.toString() + ")";
        return explainStatement;
    }

    protected String getPlanStatement(int queryNumber) {
        return "SELECT * FROM  EXPLAIN_STATEMENT s, explain_object o where s.queryno = " + queryNumber + " and s.EXPLAIN_REQUESTER = o.EXPLAIN_REQUESTER " + " and s.EXPLAIN_TIME = o.EXPLAIN_TIME " + " and s.SOURCE_NAME = o.SOURCE_NAME " + " and s.SOURCE_SCHEMA = o.SOURCE_SCHEMA ";
    }

    private synchronized int getRandomQueryNumber() {
        return this.random.nextInt(0x7FFFFFFE) + 1;
    }
}

