/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.adapters;

import com.quantum.adapters.AdabasDAdapter;
import com.quantum.adapters.DB2AS400Adapter;
import com.quantum.adapters.DB2Adapter;
import com.quantum.adapters.DB2OS390Adapter;
import com.quantum.adapters.DatabaseAdapter;
import com.quantum.adapters.DerbyAdapter;
import com.quantum.adapters.FirebirdAdapter;
import com.quantum.adapters.GenericAdapter;
import com.quantum.adapters.HsqldbAdapter;
import com.quantum.adapters.InformixAdapter;
import com.quantum.adapters.MSSQLServerAdapter;
import com.quantum.adapters.MySQLAdapter;
import com.quantum.adapters.OracleAdapter;
import com.quantum.adapters.PostgresAdapter;
import com.quantum.adapters.RedBrickAdapter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;

public class AdapterFactory {
    public static final String GENERIC = "GENERIC";
    public static final String HSQLDB = "HSQLDB";
    public static final String ORACLE = "ORACLE";
    public static final String POSTGRES = "POSTGRES";
    public static final String MYSQL = "MYSQL";
    public static final String DB2 = "DB2";
    public static final String DB2OS390 = "DB2OS390";
    public static final String DB2AS400 = "DB2AS400";
    public static final String ADABASD = "ADABASD";
    public static final String INFORMIX = "INFORMIX";
    public static final String REDBRICK = "REDBRICK";
    public static final String POINTBASE = "POINTBASE";
    public static final String SYBASE = "SYBASE";
    public static final String JDBC_ODBC_BRIDGE = "JDBC_ODBC_BRIDGE";
    public static final String MS_SQL_SERVER = "MS_SQL_SERVER";
    public static final String DERBY = "DERBY";
    public static final String FIREBIRD = "FIREBIRD";
    private static final Map DRIVER_MAP = Collections.synchronizedMap(new HashMap());
    private static AdapterFactory instance;
    private Map adapters = Collections.synchronizedMap(new HashMap());

    static {
        DRIVER_MAP.put("com.ddtek.jdbc.informix.InformixDriver", new DriverInfo(INFORMIX));
        DRIVER_MAP.put("com.ddtek.jdbc.db2.DB2Driver", new DriverInfo(DB2, "jdbc:datadirect:db2://${hostname}:${port};DatabaseName=${dbname}"));
        DRIVER_MAP.put("com.ddtek.jdbc.oracle.OracleDriver", new DriverInfo(ORACLE, "jdbc:oracle:thin:@{hostname}:{port}:{dbname}"));
        DRIVER_MAP.put("com.ddtek.jdbc.sqlserver.SQLServerDriver", new DriverInfo(GENERIC));
        DRIVER_MAP.put("com.ddtek.jdbc.sybase.SybaseDriver", new DriverInfo(SYBASE));
        DRIVER_MAP.put("com.ibm.as400.access.AS400JDBCDriver", new DriverInfo(DB2AS400));
        DRIVER_MAP.put("COM.ibm.db2.jdbc.app.DB2Driver", new DriverInfo(DB2, "jdbc:db2:{dbname}"));
        DRIVER_MAP.put("COM.ibm.db2.jdbc.net.DB2Driver", new DriverInfo(DB2, "jdbc:db2://{hostname}:{port}/{dbname}"));
        DRIVER_MAP.put("com.ibm.db2.jcc.DB2Driver", new DriverInfo(DB2, "jdbc:db2://{hostname}:{port}/{dbname}"));
        DRIVER_MAP.put("COM.ibm.db2os390.sqlj.jdbc.DB2SQLJDriver", new DriverInfo(DB2, "jdbc:db2os390sqlj:{dbname}"));
        DRIVER_MAP.put("com.inet.ora.OraDriver", new DriverInfo(ORACLE, "jdbc:oracle:thin:@{hostname}:{port}:{dbname}"));
        DRIVER_MAP.put("com.inet.drda.DRDADriver", new DriverInfo(DB2, "jdbc:inetdb2:{hostname}:{port}?database={dbname}"));
        DRIVER_MAP.put("com.inet.syb.SybDriver", new DriverInfo(SYBASE));
        DRIVER_MAP.put("com.inet.tds.TdsDriver", new DriverInfo(MS_SQL_SERVER));
        DRIVER_MAP.put("com.informix.jdbc.IfxDriver", new DriverInfo(INFORMIX, "jdbc:informix-sqli://{hostname}:{port}/{dbname}:INFORMIXSERVER={informixserver}"));
        DRIVER_MAP.put("com.microsoft.jdbc.sqlserver.SQLServerDriver", new DriverInfo(MS_SQL_SERVER, "jdbc:microsoft:sqlserver://{hostname}:{port};DatabaseName={dbname}"));
        DRIVER_MAP.put("com.mysql.jdbc.Driver", new DriverInfo(MYSQL, "jdbc:mysql://{hostname}:{port}/{dbname}"));
        DRIVER_MAP.put("com.pointbase.jdbc.jdbcUniversalDriver", new DriverInfo(POINTBASE, "jdbc:pointbase:server://{hostname}:{port}/{dbname}"));
        DRIVER_MAP.put("com.sybase.jdbc.SybDriver", new DriverInfo(SYBASE, "jdbc:sybase:Tds:{hostname}:{port}/{dbname}"));
        DRIVER_MAP.put("com.sybase.jdbc2.jdbc.SybDriver", new DriverInfo(SYBASE, "jdbc:sybase:Tds:{hostname}:{port}/{dbname}"));
        DRIVER_MAP.put("com.sybase.jdbcx.SybDriver", new DriverInfo(SYBASE, "jdbc:sybase:Tds:{hostname}:{port}/{dbname}"));
        DRIVER_MAP.put("net.sourceforge.jtds.jdbc.Driver", new DriverInfo(MS_SQL_SERVER));
        DRIVER_MAP.put("oracle.jdbc.driver.OracleDriver", new DriverInfo(ORACLE, "jdbc:oracle:thin:@{hostname}:{port}:{dbname}"));
        DRIVER_MAP.put("oracle.jdbc.OracleDriver", new DriverInfo(ORACLE, "jdbc:oracle:thin:@{hostname}:{port}:{dbname}"));
        DRIVER_MAP.put("org.gjt.mm.mysql.Driver", new DriverInfo(MYSQL, "jdbc:mysql://{hostname}:{port}/{dbname}"));
        DRIVER_MAP.put("org.hsqldb.jdbcDriver", new DriverInfo(HSQLDB));
        DRIVER_MAP.put("org.postgresql.Driver", new DriverInfo(POSTGRES, "jdbc:postgresql://{hostname}:{port}/{dbname}"));
        DRIVER_MAP.put("sun.jdbc.odbc.JdbcOdbcDriver", new DriverInfo(JDBC_ODBC_BRIDGE, "jdbc:odbc:{datasource}"));
        DRIVER_MAP.put("weblogic.jdbc.informix.InformixDriver", new DriverInfo(INFORMIX));
        DRIVER_MAP.put("weblogic.jdbc.sqlserver.SybaseDriver", new DriverInfo(SYBASE));
        DRIVER_MAP.put("org.apache.derby.jdbc.Driver20", new DriverInfo(DERBY, "jdbc:derby:{dbname}"));
        DRIVER_MAP.put("org.apache.derby.jdbc.Driver30", new DriverInfo(DERBY, "jdbc:derby:{dbname}"));
        DRIVER_MAP.put("org.apache.derby.jdbc.EmbeddedDriver", new DriverInfo(DERBY, "jdbc:derby:{dbname}"));
        DRIVER_MAP.put("org.firebirdsql.jdbc.FBDriver", new DriverInfo(FIREBIRD, "jdbc:firebirdsql:{hostname}/{port}:{dbname}"));
    }

    private AdapterFactory() {
        this.addAdapter(new GenericAdapter(GENERIC));
        this.addAdapter(new HsqldbAdapter());
        this.addAdapter(new OracleAdapter());
        this.addAdapter(new DB2Adapter());
        this.addAdapter(new DB2AS400Adapter());
        this.addAdapter(new DB2OS390Adapter());
        this.addAdapter(new PostgresAdapter());
        this.addAdapter(new MySQLAdapter());
        this.addAdapter(new AdabasDAdapter());
        this.addAdapter(new InformixAdapter());
        this.addAdapter(new RedBrickAdapter());
        this.addAdapter(new GenericAdapter(SYBASE));
        this.addAdapter(new GenericAdapter(POINTBASE));
        this.addAdapter(new GenericAdapter(JDBC_ODBC_BRIDGE));
        this.addAdapter(new MSSQLServerAdapter());
        this.addAdapter(new DerbyAdapter());
        this.addAdapter(new FirebirdAdapter());
    }

    private void addAdapter(DatabaseAdapter adapter) {
        this.adapters.put(adapter.getType(), adapter);
    }

    public static synchronized AdapterFactory getInstance() {
        if (instance == null) {
            instance = new AdapterFactory();
        }
        return instance;
    }

    public DatabaseAdapter getAdapter(String type) {
        DatabaseAdapter result = (DatabaseAdapter)this.adapters.get(type);
        if (result == null) {
            result = (DatabaseAdapter)this.adapters.get(GENERIC);
        }
        return result == null ? null : result;
    }

    public DatabaseAdapter[] getDriverList() {
        ArrayList list = new ArrayList(this.adapters.values());
        Collections.sort(list, new ComparatorImpl());
        return list.toArray(new DatabaseAdapter[list.size()]);
    }

    public String getAdapterType(String driverClassName) {
        DriverInfo driverInfo = (DriverInfo)DRIVER_MAP.get(driverClassName);
        return driverInfo == null ? null : driverInfo.getType();
    }

    public String getURLPattern(String driverClassName) {
        DriverInfo driverInfo = (DriverInfo)DRIVER_MAP.get(driverClassName);
        return driverInfo == null ? null : driverInfo.getURLPattern();
    }

    static class ComparatorImpl
    implements Comparator {
        ComparatorImpl() {
        }

        public int compare(Object arg0, Object arg1) {
            DatabaseAdapter adapter0 = (DatabaseAdapter)arg0;
            DatabaseAdapter adapter1 = (DatabaseAdapter)arg1;
            if (adapter0 == null && adapter0 != null) {
                return -1;
            }
            if (adapter0 != null && adapter1 == null) {
                return 1;
            }
            if (adapter0 == null && adapter1 == null) {
                return 0;
            }
            return adapter0.getDisplayName().compareTo(adapter1.getDisplayName());
        }
    }

    static class DriverInfo {
        private final String type;
        private final String urlPattern;

        DriverInfo(String type) {
            this(type, null);
        }

        DriverInfo(String type, String urlPattern) {
            this.type = type;
            this.urlPattern = urlPattern;
        }

        public String getType() {
            return this.type;
        }

        public String getURLPattern() {
            return this.urlPattern;
        }
    }
}

