/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.actions;

import com.quantum.ImageStore;
import com.quantum.Messages;
import com.quantum.QuantumPlugin;
import com.quantum.model.xml.ModelToXMLConverter;
import com.quantum.ui.dialog.ExceptionDisplayDialog;
import com.quantum.ui.dialog.SQLExceptionDialog;
import com.quantum.util.connection.NotConnectedException;
import com.quantum.util.xml.XMLRenderer;
import com.quantum.view.bookmark.DbObjectNode;
import com.quantum.view.bookmark.GroupNode;
import com.quantum.view.bookmark.QuickListNode;
import com.quantum.view.bookmark.SchemaNode;
import java.sql.SQLException;
import java.util.List;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.actions.SelectionListenerAction;
import org.w3c.dom.Document;

public class StructureCopyFullAction
extends SelectionListenerAction {
    private final IViewPart view;
    static /* synthetic */ Class class$0;

    public StructureCopyFullAction(IViewPart view) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.quantum.actions.StructureCopyFullAction");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        super(Messages.getString(clazz, "text"));
        this.view = view;
        this.setImageDescriptor(ImageStore.getImageDescriptor("copy"));
    }

    public void run() {
        List list = this.getSelectedNonResources();
        if (list.size() < 1) {
            MessageDialog.openInformation((Shell)this.view.getSite().getShell(), (String)"Error", (String)"You have selected nothing");
            return;
        }
        Object selection = list.get(0);
        if (selection instanceof DbObjectNode || selection instanceof GroupNode || selection instanceof SchemaNode || selection instanceof QuickListNode) {
            Document doc;
            try {
                doc = ModelToXMLConverter.getInstance().convertList(list, null, true);
            }
            catch (NotConnectedException e) {
                ExceptionDisplayDialog.openError(this.view.getSite().getShell(), null, null, e);
                e.printStackTrace();
                return;
            }
            catch (SQLException e) {
                SQLExceptionDialog.openException(this.view.getSite().getShell(), null, e);
                e.printStackTrace();
                return;
            }
            String copyText = XMLRenderer.render(doc);
            if (copyText != null) {
                QuantumPlugin.getDefault().getSysClip().setContents(new Object[]{copyText}, new Transfer[]{TextTransfer.getInstance()});
            }
        } else {
            MessageDialog.openInformation((Shell)this.view.getSite().getShell(), (String)"Error", (String)"Your selection cannot be copied. Try selecting a table, view, schema, quick list...");
            return;
        }
    }

    public boolean updateSelection(IStructuredSelection selection) {
        return true;
    }
}

