/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.actions;

import com.quantum.Messages;
import com.quantum.actions.BookmarkAction;
import com.quantum.actions.BookmarkSubActionFactory;
import com.quantum.adapters.StatementExplainer;
import com.quantum.model.Bookmark;
import com.quantum.sql.SQLResultSetCollection;
import com.quantum.sql.SQLResultSetResults;
import com.quantum.sql.parser.SQL;
import com.quantum.sql.parser.SQLParser;
import com.quantum.sql.parser.SQLProvider;
import com.quantum.ui.dialog.ConnectionUtil;
import com.quantum.ui.dialog.SQLExceptionDialog;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.Vector;
import org.eclipse.jface.action.Action;
import org.eclipse.jface.action.IMenuCreator;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Menu;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IWorkbenchPart;

public class ExplainAction
extends Action
implements IMenuCreator,
BookmarkAction {
    private final ConnectionUtil connectionUtil = new ConnectionUtil();
    private final SQLProvider sqlProvider;
    private final IWorkbenchPart workbenchPart;
    static /* synthetic */ Class class$0;

    public ExplainAction(SQLProvider sqlProvider, IWorkbenchPart workbenchPart) {
        this.sqlProvider = sqlProvider;
        this.workbenchPart = workbenchPart;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.quantum.actions.ExplainAction");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.setText(Messages.getString(clazz, "text"));
        this.setMenuCreator(this);
    }

    public Menu getMenu(Menu parent) {
        return BookmarkSubActionFactory.populateDropDownMenu(this, new Menu(parent));
    }

    public void dispose() {
    }

    public Menu getMenu(Control parent) {
        return null;
    }

    public void execute(Bookmark bookmark) {
        if (this.isEnabled(bookmark)) {
            StatementExplainer explainer = bookmark.getAdapter().getStatementExplainer();
            Connection connection = this.connectionUtil.getConnection(bookmark, this.getShell());
            Vector vector = SQLParser.parse(this.sqlProvider.getQuery());
            Iterator i = vector.iterator();
            while (i.hasNext()) {
                String sqlString = (String)i.next();
                try {
                    SQLImpl sql = new SQLImpl(sqlString);
                    SQLResultSetResults results = explainer.explain(bookmark, connection, sql);
                    SQLResultSetCollection.getInstance().addSQLResultSet(results);
                }
                catch (SQLException e) {
                    SQLExceptionDialog.openException(this.getShell(), bookmark, e);
                }
            }
        }
    }

    private Shell getShell() {
        return this.workbenchPart.getSite().getShell();
    }

    public boolean isEnabled(Bookmark bookmark) {
        return bookmark.getAdapter().isExplainSupported();
    }

    class SQLImpl
    implements SQL {
        private final String sqlCommand;

        public SQLImpl(String sqlCommand) {
            this.sqlCommand = sqlCommand;
        }

        public String getCommand() {
            String temp = this.sqlCommand.toUpperCase().trim();
            return temp.indexOf(32) >= 0 ? temp.substring(temp.indexOf(32)) : temp;
        }

        public String toString() {
            return this.sqlCommand;
        }

        public boolean isComment() {
            return false;
        }
    }
}

