/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.actions;

import com.quantum.ImageStore;
import com.quantum.Messages;
import com.quantum.QuantumPlugin;
import com.quantum.model.Column;
import com.quantum.model.EntityHolder;
import com.quantum.util.NthLevelConverter;
import com.quantum.util.QuantumUtil;
import com.quantum.util.StringUtil;
import com.quantum.util.connection.NotConnectedException;
import com.quantum.view.bookmark.ColumnNode;
import java.sql.SQLException;
import java.util.Iterator;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.dnd.TextTransfer;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.ui.actions.SelectionListenerAction;

public class CustomCopyAction
extends SelectionListenerAction {
    public static final int NUMBER_OF_ACTIONS = 3;
    public static final String CUSTOM_COPY_NAME_PREFIX = "customCopyName";
    public static final String CUSTOM_COPY_TEMPLATE_PREFIX = "customCopyTemplate";
    public static final String CUSTOM_COPY_TABLE_ITEM_PREFIX = "customCopyTableItem";
    public static final String CUSTOM_COPY_TABLE_SEPARATOR_PREFIX = "customCopyTableSeparator";
    public static final String CUSTOM_COPY_COLUMN_ITEM_PREFIX = "customCopyColumnItem";
    public static final String CUSTOM_COPY_COLUMN_SEPARATOR_PREFIX = "customCopyColumnSeparator";
    private final int ind;
    static /* synthetic */ Class class$0;

    public CustomCopyAction(int ind) {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.quantum.actions.CustomCopyAction");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        super(Messages.getString(String.valueOf(clazz.getName()) + ".text"));
        this.ind = ind;
        IPreferenceStore store = QuantumPlugin.getDefault().getPreferenceStore();
        String name = store.getString(CUSTOM_COPY_NAME_PREFIX + Integer.toString(ind));
        this.setText(name);
        this.setImageDescriptor(ImageStore.getImageDescriptor("copy"));
    }

    public void run() {
        String copyText = "";
        Iterator iter = this.getSelectedNonResources().iterator();
        NthLevelConverter converter = new NthLevelConverter();
        while (iter.hasNext()) {
            Object current = iter.next();
            if (current instanceof ColumnNode) {
                ColumnNode column = (ColumnNode)current;
                if (column == null) continue;
                converter.add(column.getColumn().getName(), column.getColumn().getParentEntity().getQualifiedName(), 0);
                continue;
            }
            if (!(current instanceof EntityHolder)) continue;
            EntityHolder currentSelec = (EntityHolder)current;
            converter.add(currentSelec.getEntity().getQualifiedName(), null, 1);
            try {
                Column[] columns = currentSelec.getEntity().getColumns();
                int i = 0;
                int length = columns == null ? 0 : columns.length;
                while (i < length) {
                    converter.add(columns[i].getName(), currentSelec.getEntity().getQualifiedName(), 0);
                    ++i;
                }
            }
            catch (NotConnectedException notConnectedException) {
            }
            catch (SQLException sQLException) {}
        }
        IPreferenceStore store = QuantumPlugin.getDefault().getPreferenceStore();
        converter.convert(Integer.toString(this.ind));
        String template = QuantumUtil.trasposeEscape(store.getString(CUSTOM_COPY_TEMPLATE_PREFIX + Integer.toString(this.ind)));
        copyText = StringUtil.substituteString(template, "${table_list}", converter.getTableList());
        QuantumPlugin.getDefault().getSysClip().setContents(new Object[]{copyText}, new Transfer[]{TextTransfer.getInstance()});
    }
}

