/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.actions;

import com.quantum.adapters.DatabaseAdapter;
import com.quantum.model.Bookmark;
import com.quantum.sql.SQLResultSetCollection;
import com.quantum.sql.SQLResultSetResults;
import com.quantum.sql.SQLResults;
import com.quantum.ui.dialog.ConnectionUtil;
import com.quantum.view.ViewHelper;
import com.quantum.view.bookmark.EntityNode;
import java.sql.Connection;
import java.util.List;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.actions.SelectionListenerAction;

public abstract class BaseSequenceAction
extends SelectionListenerAction {
    protected IViewPart view;
    private ConnectionUtil connectionUtil = new ConnectionUtil();

    protected BaseSequenceAction(String text, IViewPart view) {
        super(text);
        this.view = view;
    }

    protected Bookmark getBookmark() {
        EntityNode node = this.getEntityNode();
        return node.getBookmark();
    }

    protected Connection getConnection() {
        return this.connectionUtil.getConnection(this.getBookmark(), this.getShell());
    }

    protected EntityNode getEntityNode() {
        List list = this.getSelectedNonResources();
        return (EntityNode)list.get(0);
    }

    protected Shell getShell() {
        return this.view.getViewSite().getShell();
    }

    protected boolean updateSelection(IStructuredSelection selection) {
        boolean enabled = super.updateSelection(selection);
        return enabled && selection.size() == 1 && selection.getFirstElement() instanceof EntityNode && ((EntityNode)selection.getFirstElement()).isSequence();
    }

    public void run() {
        EntityNode sequence = this.getEntityNode();
        String name = null;
        if (sequence.isSequence()) {
            Bookmark bookmark = sequence.getBookmark();
            DatabaseAdapter adapter = bookmark.getAdapter();
            if (adapter == null) {
                return;
            }
            name = sequence.getName();
            String query = this.getQuery(sequence, name, adapter);
            SQLResults results = ViewHelper.tryGetResults(this.view, bookmark, this.getConnection(), query);
            if (results != null && results.isResultSet()) {
                SQLResultSetCollection.getInstance().addSQLResultSet((SQLResultSetResults)results);
            }
        }
    }

    protected abstract String getQuery(EntityNode var1, String var2, DatabaseAdapter var3);
}

