/*
 * Decompiled with CFR 0.152.
 */
package com.quantum;

import com.quantum.ImageStore;
import com.quantum.Messages;
import com.quantum.PluginPreferences;
import com.quantum.QuantumSaveParticipant;
import com.quantum.model.BookmarkCollection;
import com.quantum.util.versioning.VersioningHelper;
import com.quantum.util.xml.XMLHelper;
import com.quantum.view.subset.SubsetContentProvider;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import java.util.PropertyResourceBundle;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.core.resources.ISaveParticipant;
import org.eclipse.core.resources.ISavedState;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IPluginDescriptor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.dnd.Clipboard;
import org.eclipse.ui.IViewPart;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.plugin.AbstractUIPlugin;
import org.osgi.framework.BundleContext;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.SAXException;

public class QuantumPlugin
extends AbstractUIPlugin {
    private static QuantumPlugin plugin;
    private Clipboard sysClip;

    public QuantumPlugin(IPluginDescriptor descriptor) {
        this();
    }

    public QuantumPlugin() {
        plugin = this;
    }

    public static QuantumPlugin getDefault() {
        return plugin;
    }

    protected void readStateFrom(File target) {
        String fileName = target.getName();
        if (!fileName.endsWith(Messages.getString("QuantumPlugin.saveFileExtension"))) {
            try {
                BookmarkCollection.getInstance().load(target);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else {
            FileInputStream source = null;
            try {
                source = new FileInputStream(target);
            }
            catch (FileNotFoundException e1) {
                e1.printStackTrace();
                return;
            }
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            try {
                DocumentBuilder parser = factory.newDocumentBuilder();
                Document doc = parser.parse(source);
                Element root = doc.getDocumentElement();
                BookmarkCollection.getInstance().importXML(root);
                BookmarkCollection.getInstance().setChanged(false);
                SubsetContentProvider.getInstance().importXML(root);
            }
            catch (ParserConfigurationException e) {
                e.printStackTrace();
            }
            catch (SAXException e) {
                e.printStackTrace();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void startup() throws CoreException {
        super.startup();
        if (!VersioningHelper.isEclipse30()) {
            this.startupMigrationTempMethod();
        }
    }

    public void start(BundleContext bundleContext) throws Exception {
        super.start(bundleContext);
        this.startupMigrationTempMethod();
    }

    private void startupMigrationTempMethod() throws CoreException {
        ISavedState lastState = ResourcesPlugin.getWorkspace().addSaveParticipant((Plugin)this, (ISaveParticipant)new QuantumSaveParticipant());
        File file = null;
        if (lastState != null) {
            IPath location = lastState.lookup((IPath)new Path(Messages.getString("QuantumPlugin.saveDir")));
            if (location != null) {
                file = this.getStateLocation().append(location).toFile();
            }
        } else {
            String operatingSystem = Platform.getOS();
            IPreferenceStore store = this.getPreferenceStore();
            Path path = new Path(store.getString("com.quantum.plugin.defaultBookmarksFile"));
            file = (path = path.append("/def_bookmarks_" + operatingSystem + ".xml")).toFile();
            if (!file.exists()) {
                file = null;
            }
        }
        if (file != null) {
            this.readStateFrom(file);
        }
        this.sysClip = new Clipboard(null);
    }

    /*
     * WARNING - Removed back jump from a try to a catch block - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    protected void writeImportantState(File target) {
        try {
            Document document = XMLHelper.createEmptyDocument();
            Element root = (Element)document.appendChild(document.createElement(Messages.getString("ExportXMLAction.SavedData")));
            BookmarkCollection.getInstance().exportXML(root);
            SubsetContentProvider.getInstance().exportXML(root);
            OutputStreamWriter writer = new OutputStreamWriter((OutputStream)new FileOutputStream(target), "UTF-8");
            try {
                XMLHelper.write(writer, document);
            }
            catch (Throwable throwable) {
                Object var5_8 = null;
                writer.close();
                throw throwable;
            }
            {
                Object var5_9 = null;
                writer.close();
                return;
            }
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            return;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void initializeDefaultPluginPreferences() {
        IPreferenceStore store = this.getPreferenceStore();
        String operatingSystem = Platform.getOS();
        PluginPreferences.initialize(store);
        try {
            InputStream is = QuantumPlugin.getDefault().openStream((IPath)new Path("prefs/default_" + operatingSystem + ".properties"));
            PropertyResourceBundle resourceBundle = new PropertyResourceBundle(is);
            Enumeration<String> keysEnum = resourceBundle.getKeys();
            while (keysEnum.hasMoreElements()) {
                String key = keysEnum.nextElement();
                store.setDefault(key, resourceBundle.getString(key));
            }
        }
        catch (Exception exception) {}
    }

    public IWorkbenchPage getActivePage() {
        IWorkbench workbench = this.getWorkbench();
        IWorkbenchWindow window = workbench.getActiveWorkbenchWindow();
        if (window == null) {
            return null;
        }
        IWorkbenchPage page = window.getActivePage();
        return page;
    }

    public IViewPart getView(String view) {
        IViewPart tableView = null;
        try {
            IWorkbenchPage page = QuantumPlugin.getDefault().getActivePage();
            tableView = page.findView(view);
            if (tableView == null) {
                IWorkbenchPart part = page.getActivePart();
                tableView = page.showView(view);
                page.activate(part);
            }
        }
        catch (PartInitException e) {
            e.printStackTrace();
        }
        return tableView;
    }

    public Clipboard getSysClip() {
        return this.sysClip;
    }

    protected void initializeImageRegistry(ImageRegistry registry) {
        super.initializeImageRegistry(registry);
        try {
            ImageStore.initialize(this, registry, this.getIconLocation());
        }
        catch (MalformedURLException malformedURLException) {}
    }

    private URL getIconLocation() throws MalformedURLException {
        URL installURL = this.getBundle().getEntry("/");
        return new URL(installURL, "icons/");
    }
}

