/*
 * Decompiled with CFR 0.152.
 */
package com.quantum;

import com.quantum.QuantumPlugin;
import com.quantum.util.versioning.VersioningHelper;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.swt.graphics.Image;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ImageStore {
    private static final Map imageDescriptorMap = Collections.synchronizedMap(new HashMap());
    private static final String VERSION_2 = "_2x";
    private static final String GIF_FILE_EXTENSION = ".gif";
    private static final String JPG_FILE_EXTENSION = ".jpg";
    public static final String ADD = "add";
    public static final String ADD_SCHEMA = "add_schema";
    public static final String APPEND = "append";
    public static final String AUTOCOMMIT = "autocommit";
    public static final String BEANSHELL = "beanshell";
    public static final String BOOKMARK = "bookmarks";
    public static final String BOOKMARKFILE = "bookmarkfile";
    public static final String CLASS = "class";
    public static final String CLEAR = "clear";
    public static final String CLOSE = "close";
    public static final String CLOSE_DISABLED = "close_disabled";
    public static final String CLOSE_ALL = "close_all";
    public static final String CLOSE_ALL_DISABLED = "close_all_disabled";
    public static final String COLLAPSE_ALL = "collapse_all";
    public static final String COLUMN = "column";
    public static final String CONNECT = "connect";
    public static final String CONNECTED = "connected";
    public static final String COPY = "copy";
    public static final String CUT = "cut";
    public static final String DELETE = "delete";
    public static final String DISCONNECT = "disconnect";
    public static final String DRIVER = "driver";
    public static final String EDIT = "edit";
    public static final String ENTITYGROUP = "entitygroup";
    public static final String EXPORT = "export";
    public static final String EXTERNAL_JAR = "external_jar";
    public static final String FILTER = "filter";
    public static final String FOREIGNKEY = "foreignkey";
    public static final String FULLDATA = "fulldata";
    public static final String GRID = "grid";
    public static final String GROUP = "group";
    public static final String IMPORT = "import";
    public static final String JAVA_CUP = "javacup";
    public static final String KEY = "key";
    public static final String KEYCOLUMN = "keycolumn";
    public static final String LOG = "log";
    public static final String MISSINGSCHEMA = "missingschema";
    public static final String MISSINGTABLE = "table";
    public static final String NEXT = "next";
    public static final String NEW_BOOKMARK = "new_bookmark";
    public static final String NEW_BOOKMARK_WIZARD = "new_bookmark_wizard";
    public static final String OPEN_TABLE = "table";
    public static final String PASTE = "paste";
    public static final String PLAY = "play";
    public static final String PREVIOUS = "previous";
    public static final String QMODEL = "qmodel";
    public static final String QUANTUM = "quantum";
    public static final String REFRESH = "refresh";
    public static final String ROLLBACK = "rollback";
    public static final String SAMPLE = "sample";
    public static final String SCHEMA = "schema";
    public static final String SCRIPT = "script";
    public static final String SEQUENCE = "sequence";
    public static final String STATEMENT = "statement";
    public static final String STOP = "stop";
    public static final String SUBSET = "subset";
    public static final String SUCCESS = "success";
    public static final String TABLE = "bigtable";
    public static final String SYNONYM_TABLE = "big_syn_table";
    public static final String TABLE_DETAILS = "table_details";
    public static final String TEMPLATE = "template";
    public static final String TRIGGER = "trigger";
    public static final String USER = "user";
    public static final String VIEW = "view";
    public static final String WARNING = "warning";
    public static final String XML = "xml";
    public static final String CHECKED = "checked";
    public static final String UNCHECKED = "unchecked";
    public static final String SEARCH = "search_results_view";
    public static final String VALUE = "value";
    public static final String PROCEDURE = "procedure";
    public static final String ALL_PROCEDURES = "all_procedures";

    public static ImageDescriptor getImageDescriptor(String imageName) {
        return ImageStore.getImageDescriptor(imageName, QuantumPlugin.getDefault());
    }

    public static Image getImage(String imageName) {
        return ImageStore.getImage(imageName, QuantumPlugin.getDefault());
    }

    public static Image getImage(String imageName, AbstractUIPlugin plugin) {
        ImageRegistry registry = plugin.getImageRegistry();
        String key = ImageStore.stripSuffix(imageName);
        Image image = registry.get(ImageStore.getVersionAppropriateImage(key, plugin));
        return image;
    }

    public static ImageDescriptor getImageDescriptor(String imageName, AbstractUIPlugin plugin) {
        ImageRegistry registry = plugin.getImageRegistry();
        String key = ImageStore.stripSuffix(imageName);
        key = ImageStore.getVersionAppropriateImage(key, plugin);
        if (VersioningHelper.isEclipse21OrHigher()) {
            return VersioningHelper.getDescriptor(registry, key);
        }
        return (ImageDescriptor)ImageStore.getImageDescriptorMap(plugin).get(key);
    }

    private static Map getImageDescriptorMap(AbstractUIPlugin plugin) {
        String key = plugin.getClass().getName();
        if (!imageDescriptorMap.containsKey(key)) {
            imageDescriptorMap.put(key, new HashMap());
        }
        return (Map)imageDescriptorMap.get(key);
    }

    private static String stripSuffix(String imageName) {
        if (imageName.endsWith(GIF_FILE_EXTENSION)) {
            return imageName.substring(0, imageName.length() - 4);
        }
        if (imageName.endsWith(JPG_FILE_EXTENSION)) {
            return imageName.substring(0, imageName.length() - 4);
        }
        return imageName;
    }

    private static String getVersionAppropriateImage(String imageName, AbstractUIPlugin plugin) {
        String version2Key = String.valueOf(imageName) + VERSION_2;
        return !VersioningHelper.isEclipse30() && ImageStore.getImageDescriptorMap(plugin).containsKey(version2Key) ? version2Key : imageName;
    }

    static void initialize(AbstractUIPlugin plugin, ImageRegistry registry, URL url) {
        ImageStore.addImage(plugin, registry, url, ADD);
        ImageStore.addImage(plugin, registry, url, BOOKMARK);
        ImageStore.addImage(plugin, registry, url, DISCONNECT);
        ImageStore.addImage(plugin, registry, url, ADD);
        ImageStore.addImage(plugin, registry, url, ADD_SCHEMA);
        ImageStore.addImage(plugin, registry, url, APPEND);
        ImageStore.addImage(plugin, registry, url, AUTOCOMMIT);
        ImageStore.addImage(plugin, registry, url, BOOKMARK);
        ImageStore.addImage(plugin, registry, url, BOOKMARKFILE);
        ImageStore.addImage(plugin, registry, url, CLASS);
        ImageStore.addImage(plugin, registry, url, CLEAR);
        ImageStore.addImage(plugin, registry, url, CLOSE);
        ImageStore.addImage(plugin, registry, url, CLOSE_DISABLED);
        ImageStore.addImage(plugin, registry, url, CLOSE_ALL);
        ImageStore.addImage(plugin, registry, url, CLOSE_ALL_DISABLED);
        ImageStore.addImage(plugin, registry, url, COLLAPSE_ALL);
        ImageStore.addImage(plugin, registry, url, COLUMN);
        ImageStore.addImage(plugin, registry, url, CONNECT);
        ImageStore.addImage(plugin, registry, url, CONNECTED);
        ImageStore.addImage(plugin, registry, url, COPY);
        ImageStore.addImage(plugin, registry, url, CUT);
        ImageStore.addImage(plugin, registry, url, DELETE);
        ImageStore.addImage(plugin, registry, url, DISCONNECT);
        ImageStore.addImage(plugin, registry, url, DRIVER);
        ImageStore.addImage(plugin, registry, url, EDIT);
        ImageStore.addImage(plugin, registry, url, ENTITYGROUP);
        ImageStore.addImage(plugin, registry, url, EXPORT);
        ImageStore.addImage(plugin, registry, url, EXTERNAL_JAR);
        ImageStore.addImage(plugin, registry, url, FILTER);
        ImageStore.addImage(plugin, registry, url, FOREIGNKEY);
        ImageStore.addImage(plugin, registry, url, FULLDATA);
        ImageStore.addImage(plugin, registry, url, GRID);
        ImageStore.addImage(plugin, registry, url, GROUP);
        ImageStore.addImage(plugin, registry, url, IMPORT);
        ImageStore.addImage(plugin, registry, url, JAVA_CUP);
        ImageStore.addImage(plugin, registry, url, KEY);
        ImageStore.addImage(plugin, registry, url, KEYCOLUMN);
        ImageStore.addImage(plugin, registry, url, LOG);
        ImageStore.addImage(plugin, registry, url, MISSINGSCHEMA);
        ImageStore.addImage(plugin, registry, url, "table");
        ImageStore.addImage(plugin, registry, url, NEXT);
        ImageStore.addImage(plugin, registry, url, NEW_BOOKMARK);
        ImageStore.addImage(plugin, registry, url, NEW_BOOKMARK_WIZARD, JPG_FILE_EXTENSION);
        ImageStore.addImage(plugin, registry, url, PASTE);
        ImageStore.addImage(plugin, registry, url, PLAY);
        ImageStore.addImage(plugin, registry, url, PREVIOUS);
        ImageStore.addImage(plugin, registry, url, QMODEL);
        ImageStore.addImage(plugin, registry, url, QUANTUM);
        ImageStore.addImage(plugin, registry, url, REFRESH);
        ImageStore.addImage(plugin, registry, url, ROLLBACK);
        ImageStore.addImage(plugin, registry, url, SAMPLE);
        ImageStore.addImage(plugin, registry, url, SCHEMA);
        ImageStore.addImage(plugin, registry, url, SCRIPT);
        ImageStore.addImage(plugin, registry, url, SEQUENCE);
        ImageStore.addImage(plugin, registry, url, STATEMENT);
        ImageStore.addImage(plugin, registry, url, STOP);
        ImageStore.addImage(plugin, registry, url, SUBSET);
        ImageStore.addImage(plugin, registry, url, SUCCESS);
        ImageStore.addImage(plugin, registry, url, TABLE);
        ImageStore.addImage(plugin, registry, url, SYNONYM_TABLE);
        ImageStore.addImage(plugin, registry, url, TABLE_DETAILS);
        ImageStore.addImage(plugin, registry, url, TEMPLATE);
        ImageStore.addImage(plugin, registry, url, TRIGGER);
        ImageStore.addImage(plugin, registry, url, USER);
        ImageStore.addImage(plugin, registry, url, VIEW);
        ImageStore.addImage(plugin, registry, url, WARNING);
        ImageStore.addImage(plugin, registry, url, XML);
        ImageStore.addImage(plugin, registry, url, CHECKED);
        ImageStore.addImage(plugin, registry, url, UNCHECKED);
        ImageStore.addImage(plugin, registry, url, SEARCH);
        ImageStore.addImage(plugin, registry, url, VALUE);
        ImageStore.addImage(plugin, registry, url, PROCEDURE);
        ImageStore.addImage(plugin, registry, url, ALL_PROCEDURES);
        if (!VersioningHelper.isEclipse30()) {
            ImageStore.addImage(plugin, registry, url, "close_2x");
            ImageStore.addImage(plugin, registry, url, "close_all_2x");
            ImageStore.addImage(plugin, registry, url, "collapse_all_2x");
            ImageStore.addImage(plugin, registry, url, "copy_2x");
            ImageStore.addImage(plugin, registry, url, "delete_2x");
            ImageStore.addImage(plugin, registry, url, "export_2x");
            ImageStore.addImage(plugin, registry, url, "external_jar_2x");
            ImageStore.addImage(plugin, registry, url, "import_2x");
            ImageStore.addImage(plugin, registry, url, "paste_2x");
            ImageStore.addImage(plugin, registry, url, "refresh_2x");
        }
    }

    public static void addImage(AbstractUIPlugin plugin, ImageRegistry registry, URL url, String key) {
        ImageStore.addImage(plugin, registry, url, key, GIF_FILE_EXTENSION);
    }

    public static void addImage(AbstractUIPlugin plugin, ImageRegistry registry, URL url, String key, String extension) {
        try {
            ImageDescriptor descriptor = ImageDescriptor.createFromURL((URL)new URL(url, String.valueOf(key) + extension));
            ImageStore.getImageDescriptorMap(plugin).put(key, descriptor);
            registry.put(key, descriptor);
        }
        catch (MalformedURLException malformedURLException) {}
    }
}

