/*
 * Decompiled with CFR 0.152.
 */
package com.quantum;

import com.quantum.adapters.DatabaseAdapter;
import com.quantum.model.Bookmark;
import com.quantum.model.BookmarkCollection;
import com.quantum.model.Schema;
import com.quantum.sql.MultiSQLServer;
import com.quantum.sql.SQLResultSetCollection;
import com.quantum.sql.SQLResultSetResults;
import com.quantum.sql.SQLResults;
import com.quantum.ui.dialog.ConnectionUtil;
import com.quantum.util.connection.Connectable;
import com.quantum.util.connection.NotConnectedException;
import com.quantum.util.xml.XMLRenderer;
import com.quantum.view.SQLQueryView;
import java.sql.Connection;
import java.sql.SQLException;
import org.eclipse.swt.widgets.Shell;
import org.w3c.dom.Node;

public class ExternalInterface {
    public static String[] getBookmarkNames() {
        return BookmarkCollection.getInstance().getBookmarkNames();
    }

    public static boolean isBookmarkInQuantum(String bookmarkName) {
        return BookmarkCollection.getInstance().find(bookmarkName) != null;
    }

    public static boolean isBookmarkConnected(String bookmarkName) {
        Bookmark bookmark = BookmarkCollection.getInstance().find(bookmarkName);
        if (bookmark == null) {
            return false;
        }
        return bookmark.isConnected();
    }

    public static Connection connectBookmark(String bookmarkName, Shell shell) {
        Bookmark bookmark = BookmarkCollection.getInstance().find(bookmarkName);
        if (bookmark == null) {
            return null;
        }
        ConnectionUtil connectionUtil = new ConnectionUtil();
        return connectionUtil.connect(bookmark, shell);
    }

    public static String[] getDatabaseObjectNames(String bookmarkName, String schema, String[] types, String tableNamePrefix) {
        Bookmark bookmark = BookmarkCollection.getInstance().find(bookmarkName);
        if (bookmark == null || !bookmark.isConnected()) {
            return null;
        }
        try {
            bookmark.getObjectsForSchema(new Schema(schema), types[0]);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return null;
    }

    public static String[] getMatchingColumnNames(String schemaName, String bookmarkName, String columnPrefix, String tableName, boolean qualified) throws NotConnectedException {
        Bookmark bookmark = BookmarkCollection.getInstance().find(bookmarkName);
        if (bookmark == null) {
            return null;
        }
        Connection connection = bookmark.getConnection();
        try {
            return MultiSQLServer.getInstance().getMatchingColumnNames(connection, schemaName, tableName, columnPrefix, qualified);
        }
        catch (SQLException sQLException) {
            return new String[0];
        }
    }

    public static String[] getMatchingTableNames(String schemaName, String bookmarkName, String namePrefix, String[] types, boolean qualified) throws NotConnectedException {
        Bookmark bookmark = BookmarkCollection.getInstance().find(bookmarkName);
        if (bookmark == null) {
            return null;
        }
        Connection connection = bookmark.getConnection();
        try {
            return MultiSQLServer.getInstance().getMatchingTableNames(connection, schemaName, namePrefix, types, qualified);
        }
        catch (SQLException sQLException) {
            return new String[0];
        }
    }

    public static void displayTable(String bookmarkName, String tableName) throws NotConnectedException, SQLException {
        Bookmark bookmark = BookmarkCollection.getInstance().find(bookmarkName);
        if (bookmark == null) {
            return;
        }
        Connection connection = bookmark.getConnection();
        DatabaseAdapter adapter = bookmark.getAdapter();
        String query = adapter.getTableQuery(bookmark.filterQuoteName(tableName));
        SQLResults results = MultiSQLServer.getInstance().execute((Connectable)bookmark, connection, null, query);
        if (results != null && results.isResultSet()) {
            SQLResultSetCollection.getInstance().addSQLResultSet((SQLResultSetResults)results);
        }
    }

    public static String xmlToString(Node node) {
        return XMLRenderer.render(node);
    }

    public static int getNumberOfResultSets() {
        return SQLResultSetCollection.getInstance().getResultSets().length;
    }

    public static String[][] getDataFromResultSet(int i) {
        SQLResultSetResults[] resultSets = SQLResultSetCollection.getInstance().getResultSets();
        if (i < 0 || i >= resultSets.length) {
            return null;
        }
        return resultSets[i].getDataAsStrings();
    }

    public static String getTextFromQueryView() {
        String result = "";
        SQLQueryView queryView = SQLQueryView.getInstance();
        if (queryView != null) {
            result = queryView.getQuery();
        }
        return result;
    }
}

