/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.dbunit.wizard;

import com.quantum.ImageStore;
import com.quantum.QuantumPlugin;
import com.quantum.dbunit.MessageUtil;
import com.quantum.dbunit.QuantumDbUnitPlugin;
import com.quantum.dbunit.wizard.ConverterDBUnit;
import com.quantum.dbunit.wizard.ExportDbUnitDetailsPage;
import com.quantum.model.Entity;
import com.quantum.ui.dialog.ExceptionDisplayDialog;
import com.quantum.view.bookmark.BookmarkView;
import com.quantum.view.bookmark.EntityNode;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.File;
import java.io.FileOutputStream;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.wizard.IWizardPage;
import org.eclipse.jface.wizard.Wizard;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IExportWizard;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ExportDbUnitWizard
extends Wizard
implements IExportWizard,
PropertyChangeListener {
    private ExportDbUnitDetailsPage page1;

    public ExportDbUnitWizard() {
        this.setWindowTitle(MessageUtil.getString(this.getClass(), "windowTitle"));
        this.setDefaultPageImageDescriptor(ImageStore.getImageDescriptor((String)"export_dbunit", (AbstractUIPlugin)QuantumDbUnitPlugin.getDefault()));
    }

    public boolean performFinish() {
        boolean successful = false;
        File file = new File(this.page1.getFileName());
        IPreferenceStore store = QuantumPlugin.getDefault().getPreferenceStore();
        boolean confirmOverwrite = store.getBoolean("com.quantum.export.confirmOverwrite");
        if (!file.exists() || !confirmOverwrite || file.exists() && MessageDialog.openConfirm((Shell)this.getShell(), (String)MessageUtil.getString(this.getClass(), "overwriteTitle"), (String)MessageUtil.getString(this.getClass(), "confirmOverwrite", new Object[]{file.getAbsoluteFile()}))) {
            try {
                Entity[] entities = this.page1.getEntities();
                File outputFile = new File(this.page1.getFileName());
                FileOutputStream writer = new FileOutputStream(outputFile);
                ConverterDBUnit converter = new ConverterDBUnit();
                converter.convert(writer, entities, this.page1.getSchema(), this.page1.useDBSequence(), this.page1.isQualifyNames(), this.getShell());
                writer.close();
                successful = true;
            }
            catch (Exception e) {
                e.printStackTrace();
                ExceptionDisplayDialog.openError((Shell)this.getShell(), null, null, (Throwable)e);
            }
        }
        return successful;
    }

    public void init(IWorkbench workbench, IStructuredSelection selection) {
        Object[] nodes = BookmarkView.getInstance().getSelection().toArray();
        if (nodes.length == 0) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)"Invalid selection", (String)"Please select some tables or views in the Quantum Bookmark View");
            return;
        }
        boolean oneTable = false;
        boolean oneView = false;
        boolean oneSynonym = false;
        int i = 0;
        while (i < nodes.length) {
            Object node = nodes[i];
            if (!(node instanceof EntityNode) || !((EntityNode)node).isTable() && !((EntityNode)node).isView()) {
                MessageDialog.openInformation((Shell)this.getShell(), (String)"Invalid selection", (String)"Please select ONLY Tables or Views in the Quantum Bookmark View");
                return;
            }
            Entity entity = ((EntityNode)node).getEntity();
            if (entity.isSynonym()) {
                oneSynonym = true;
                if (oneTable || oneView) {
                    break;
                }
            } else if (entity.getType().equals("TABLE")) {
                oneTable = true;
                if (oneSynonym || oneView) {
                    break;
                }
            } else if (entity.getType().equals("VIEW")) {
                oneView = true;
                if (oneSynonym || oneTable) break;
            }
            ++i;
        }
        if (oneSynonym && (oneTable || oneView) || oneTable && oneView) {
            MessageDialog.openInformation((Shell)this.getShell(), (String)"Invalid selection", (String)"Sorry, you cannot mix Tables, Views or Synonyms in the same selection");
            return;
        }
        this.page1 = new ExportDbUnitDetailsPage("page1");
    }

    public void dispose() {
        super.dispose();
    }

    public void addPages() {
        if (this.page1 != null) {
            this.addPage((IWizardPage)this.page1);
        }
    }

    public void propertyChange(PropertyChangeEvent arg0) {
    }
}

