/*
 * Decompiled with CFR 0.152.
 */
package com.quantum.dbunit.wizard;

import com.quantum.ImageStore;
import com.quantum.QuantumPlugin;
import com.quantum.dbunit.MessageUtil;
import com.quantum.model.Entity;
import com.quantum.view.bookmark.BookmarkView;
import com.quantum.view.bookmark.EntityNode;
import com.quantum.view.widget.SimpleLabelProvider;
import java.io.File;
import org.eclipse.jface.viewers.IBaseLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.IStructuredContentProvider;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.FileDialog;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.plugin.AbstractUIPlugin;

public class ExportDbUnitDetailsPage
extends WizardPage {
    private String fileName;
    private String schema = null;
    private TableViewer tableViewer;
    private ContentProviderImpl contentProvider;
    private Entity[] entities;
    private boolean useDBSequence = false;
    private boolean qualifyNames = false;
    static /* synthetic */ Class class$0;

    protected void refreshTable() {
    }

    public void dispose() {
        super.dispose();
    }

    protected ExportDbUnitDetailsPage(String pageName) {
        super(pageName);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.quantum.dbunit.wizard.ExportDbUnitDetailsPage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.setTitle(MessageUtil.getString(clazz, "title"));
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("com.quantum.dbunit.wizard.ExportDbUnitDetailsPage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.setDescription(MessageUtil.getString(clazz2, "description"));
    }

    public void createControl(Composite parent) {
        Composite composite = new Composite(parent, 0);
        composite.setLayout((Layout)new GridLayout(1, false));
        composite.setLayoutData((Object)new GridData(1808));
        Label label = new Label(composite, 0);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.quantum.dbunit.wizard.ExportDbUnitDetailsPage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        label.setText(MessageUtil.getString(clazz, "selectedEntities"));
        label.setLayoutData((Object)new GridData(2));
        this.tableViewer = new TableViewer(composite);
        this.tableViewer.setLabelProvider((IBaseLabelProvider)new SimpleLabelProvider(ImageStore.getImage((String)"bigtable", (AbstractUIPlugin)QuantumPlugin.getDefault())));
        this.contentProvider = new ContentProviderImpl();
        this.tableViewer.setContentProvider((IContentProvider)this.contentProvider);
        this.tableViewer.setInput((Object)BookmarkView.getInstance().getSelection());
        this.tableViewer.getControl().setLayoutData((Object)new GridData(1808));
        Object[] nodes = this.contentProvider.getElements(BookmarkView.getInstance().getSelection());
        this.entities = new Entity[nodes.length];
        int i = 0;
        while (i < nodes.length) {
            EntityNode entityNode;
            Object node = nodes[i];
            if (node instanceof EntityNode && ((entityNode = (EntityNode)node).isTable() || entityNode.isView())) {
                this.entities[i] = entityNode.getEntity();
            }
            ++i;
        }
        Group group = new Group(composite, 0);
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("com.quantum.dbunit.wizard.ExportDbUnitDetailsPage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        group.setText(MessageUtil.getString(clazz2, "options"));
        group.setLayout((Layout)new GridLayout(1, false));
        group.setLayoutData((Object)new GridData(768));
        Button useDBSequenceButton = new Button((Composite)group, 32);
        useDBSequenceButton.setText(MessageUtil.getString(((Object)((Object)this)).getClass(), "useDBSequence"));
        useDBSequenceButton.setSelection(this.useDBSequence);
        useDBSequenceButton.setLayoutData((Object)new GridData(32));
        useDBSequenceButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ExportDbUnitDetailsPage.this.useDBSequence = ((Button)event.getSource()).getSelection();
            }
        });
        Button qualifyNamesButton = new Button((Composite)group, 32);
        qualifyNamesButton.setText(MessageUtil.getString(((Object)((Object)this)).getClass(), "qualifyNames"));
        qualifyNamesButton.setLayoutData((Object)new GridData(32));
        qualifyNamesButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                ExportDbUnitDetailsPage.this.qualifyNames = ((Button)event.getSource()).getSelection();
            }
        });
        if (this.entities.length > 0 && ExportDbUnitDetailsPage.areAllEntitiesSameSchema(this.entities)) {
            this.schema = this.entities[0].getSchema();
            this.qualifyNames = false;
            qualifyNamesButton.setSelection(false);
        } else {
            this.qualifyNames = true;
            qualifyNamesButton.setSelection(true);
            qualifyNamesButton.setEnabled(false);
        }
        Label blankArea = new Label(composite, 0);
        blankArea.setText("");
        this.createDestinationArea(composite);
        this.setControl((Control)composite);
        this.updateState();
    }

    private void createDestinationArea(Composite composite) {
        Composite fileArea = new Composite(composite, 0);
        fileArea.setLayout((Layout)new GridLayout(3, false));
        fileArea.setLayoutData((Object)new GridData(770));
        Label label = new Label(fileArea, 0);
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("com.quantum.dbunit.wizard.ExportDbUnitDetailsPage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        label.setText(MessageUtil.getString(clazz, "fileName"));
        final Text fileNameText = new Text(fileArea, 2048);
        fileNameText.setLayoutData((Object)new GridData(768));
        fileNameText.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent event) {
                String filename = ((Text)event.getSource()).getText();
                filename = filename.indexOf(46) < 0 ? String.valueOf(filename) + ".xml" : filename;
                ExportDbUnitDetailsPage.this.setFileName(filename);
                ExportDbUnitDetailsPage.this.updateState();
            }
        });
        Button button = new Button(fileArea, 0);
        Class<?> clazz2 = class$0;
        if (clazz2 == null) {
            try {
                clazz2 = class$0 = Class.forName("com.quantum.dbunit.wizard.ExportDbUnitDetailsPage");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        button.setText(MessageUtil.getString(clazz2, "browse"));
        button.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent event) {
                FileDialog dialog = new FileDialog(ExportDbUnitDetailsPage.this.getShell(), 8192);
                dialog.setFilterExtensions(new String[]{".xml"});
                String[] stringArray = new String[1];
                Class<?> clazz = class$0;
                if (clazz == null) {
                    try {
                        clazz = class$0 = Class.forName("com.quantum.dbunit.wizard.ExportDbUnitDetailsPage");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                stringArray[0] = MessageUtil.getString(clazz, "xmlFiles");
                dialog.setFilterNames(stringArray);
                String filename = dialog.open();
                if (filename != null) {
                    fileNameText.setText(filename);
                    ExportDbUnitDetailsPage.this.setFileName(filename);
                    ExportDbUnitDetailsPage.this.updateState();
                }
            }
        });
    }

    protected void updateState() {
        boolean pageComplete = this.entities != null && this.entities.length > 0;
        this.setPageComplete(pageComplete &= this.fileName != null && !new File(this.fileName).isDirectory());
    }

    public String getFileName() {
        return this.fileName;
    }

    protected void setFileName(String fileName) {
        this.fileName = fileName;
    }

    public Entity[] getEntities() {
        return this.entities;
    }

    public void setEntities(Entity[] entities) {
        this.entities = entities;
    }

    public boolean useDBSequence() {
        return this.useDBSequence;
    }

    public boolean isQualifyNames() {
        return this.qualifyNames;
    }

    public String getSchema() {
        return this.schema;
    }

    public static boolean areAllEntitiesSameSchema(Entity[] entities) {
        if (entities.length < 1) {
            return true;
        }
        String firstSchema = entities[0].getSchema();
        int i = 1;
        while (i < entities.length) {
            Entity entity = entities[i];
            if (firstSchema == null ? entity.getSchema() != null : entity.getSchema() == null || !firstSchema.equals(entity.getSchema())) {
                return false;
            }
            ++i;
        }
        return true;
    }

    public class ContentProviderImpl
    implements IStructuredContentProvider {
        public Object[] getElements(Object inputElement) {
            if (inputElement instanceof StructuredSelection) {
                Object[] entities = ((StructuredSelection)inputElement).toArray();
                return entities;
            }
            return null;
        }

        public void dispose() {
        }

        public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
        }
    }
}

