/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.coding;

import com.puppycrawl.tools.checkstyle.api.Check;
import com.puppycrawl.tools.checkstyle.api.DetailAST;
import com.puppycrawl.tools.checkstyle.api.ScopeUtils;
import com.puppycrawl.tools.checkstyle.checks.CheckUtils;
import java.util.Arrays;

public class MagicNumberCheck
extends Check {
    private double[] mIgnoreNumbers = new double[]{-1.0, 0.0, 1.0, 2.0};

    public int[] getDefaultTokens() {
        return new int[]{142, 140, 137, 141};
    }

    public void visitToken(DetailAST aAST) {
        if (!this.inIgnoreList(aAST) && !this.isConstantDefinition(aAST)) {
            String text = aAST.getText();
            int columnNo = aAST.getColumnNo();
            DetailAST parent = aAST.getParent();
            if (parent.getType() == 31) {
                --columnNo;
                text = "-" + text;
            } else if (parent.getType() == 32) {
                --columnNo;
                text = "+" + text;
            }
            this.log(aAST.getLineNo(), columnNo, "magic.number", (Object)text);
        }
    }

    private boolean inIgnoreList(DetailAST aAST) {
        double value = CheckUtils.parseDouble(aAST.getText(), aAST.getType());
        DetailAST parent = aAST.getParent();
        if (parent.getType() == 31) {
            value = -1.0 * value;
        }
        return Arrays.binarySearch(this.mIgnoreNumbers, value) >= 0;
    }

    private boolean isConstantDefinition(DetailAST aAST) {
        if (ScopeUtils.inInterfaceBlock(aAST)) {
            return true;
        }
        DetailAST parent = aAST.getParent();
        if (parent == null) {
            return false;
        }
        while (parent.getType() == 31 || parent.getType() == 32 || parent.getType() == 23) {
            parent = parent.getParent();
        }
        if (parent == null || parent.getType() != 28) {
            return false;
        }
        if ((parent = parent.getParent()) != null && parent.getType() == 29) {
            parent = parent.getParent();
        }
        if (parent == null || parent.getType() != 80) {
            return false;
        }
        if ((parent = parent.getParent()) == null || parent.getType() != 10) {
            return false;
        }
        DetailAST modifiersAST = parent.findFirstToken(5);
        return modifiersAST.branchContains(39);
    }

    public void setIgnoreNumbers(double[] aList) {
        if (aList == null || aList.length == 0) {
            this.mIgnoreNumbers = new double[0];
        } else {
            this.mIgnoreNumbers = new double[aList.length];
            System.arraycopy(aList, 0, this.mIgnoreNumbers, 0, aList.length);
            Arrays.sort(this.mIgnoreNumbers);
        }
    }
}

