/*
 * Decompiled with CFR 0.152.
 */
package org.apache.xerces.impl.xs.models;

import org.apache.xerces.impl.dtd.models.CMNode;
import org.apache.xerces.impl.xs.XSComplexTypeDecl;
import org.apache.xerces.impl.xs.XSDeclarationPool;
import org.apache.xerces.impl.xs.XSElementDecl;
import org.apache.xerces.impl.xs.XSParticleDecl;
import org.apache.xerces.impl.xs.models.XSAllCM;
import org.apache.xerces.impl.xs.models.XSCMBinOp;
import org.apache.xerces.impl.xs.models.XSCMLeaf;
import org.apache.xerces.impl.xs.models.XSCMUniOp;
import org.apache.xerces.impl.xs.models.XSCMValidator;
import org.apache.xerces.impl.xs.models.XSDFACM;
import org.apache.xerces.impl.xs.models.XSEmptyCM;
import org.apache.xerces.impl.xs.models.XSSimpleCM;
import org.apache.xerces.xni.QName;

public class CMBuilder {
    private final QName fQName1 = new QName();
    private final QName fQName2 = new QName();
    private XSDeclarationPool fDeclPool = null;
    private int fLeafCount;

    public CMBuilder(XSDeclarationPool xSDeclarationPool) {
        this.fDeclPool = xSDeclarationPool;
    }

    public XSCMValidator getContentModel(XSComplexTypeDecl xSComplexTypeDecl) {
        short s = xSComplexTypeDecl.getContentType();
        if (s == 1 || s == 0) {
            return null;
        }
        XSCMValidator xSCMValidator = null;
        XSParticleDecl xSParticleDecl = xSComplexTypeDecl.getParticle();
        if (xSParticleDecl != null) {
            xSParticleDecl = this.expandParticleTree(xSParticleDecl);
        }
        if (xSParticleDecl == null) {
            xSCMValidator = new XSEmptyCM();
        } else if (s == 2) {
            xSCMValidator = this.createChildModel(xSParticleDecl, true);
        } else if (s == 3) {
            xSCMValidator = this.createChildModel(xSParticleDecl, false);
        } else {
            throw new RuntimeException("Unknown content type for a element decl in getElementContentModelValidator() in Grammar class");
        }
        return xSCMValidator;
    }

    private XSParticleDecl expandParticleTree(XSParticleDecl xSParticleDecl) {
        int n = xSParticleDecl.fMaxOccurs;
        int n2 = xSParticleDecl.fMinOccurs;
        short s = xSParticleDecl.fType;
        if (s == 2 || s == 1) {
            return this.expandContentModel(xSParticleDecl, n2, n);
        }
        if (s == 3 || s == 5 || s == 4) {
            Object object = xSParticleDecl.fValue;
            Object object2 = xSParticleDecl.fOtherValue;
            object = this.expandParticleTree((XSParticleDecl)object);
            if (object2 != null) {
                object2 = this.expandParticleTree((XSParticleDecl)object2);
            }
            if (object == null && object2 == null) {
                return null;
            }
            if (object == null) {
                return this.expandContentModel((XSParticleDecl)object2, n2, n);
            }
            if (object2 == null) {
                return this.expandContentModel((XSParticleDecl)object, n2, n);
            }
            XSParticleDecl xSParticleDecl2 = new XSParticleDecl();
            xSParticleDecl2.fType = xSParticleDecl.fType;
            xSParticleDecl2.fValue = object;
            xSParticleDecl2.fOtherValue = object2;
            return this.expandContentModel(xSParticleDecl2, n2, n);
        }
        if (s == 0) {
            return null;
        }
        return xSParticleDecl;
    }

    private XSCMValidator createChildModel(XSParticleDecl xSParticleDecl, boolean bl) {
        Object object;
        short s = xSParticleDecl.fType;
        if (s != 2) {
            if (bl) {
                if (s == 5) {
                    XSAllCM xSAllCM = new XSAllCM(false);
                    this.gatherAllLeaves((XSParticleDecl)xSParticleDecl.fValue, xSAllCM);
                    this.gatherAllLeaves((XSParticleDecl)xSParticleDecl.fOtherValue, xSAllCM);
                    return xSAllCM;
                }
                if (s == 6) {
                    object = (XSParticleDecl)xSParticleDecl.fValue;
                    if (s == 5) {
                        XSAllCM xSAllCM = new XSAllCM(true);
                        this.gatherAllLeaves((XSParticleDecl)object, xSAllCM);
                        return xSAllCM;
                    }
                }
            } else {
                if (s == 1) {
                    if (xSParticleDecl.fValue == null && xSParticleDecl.fOtherValue == null) {
                        throw new RuntimeException("ImplementationMessages.VAL_NPCD");
                    }
                    return new XSSimpleCM(s, (XSElementDecl)xSParticleDecl.fValue);
                }
                if (s == 3 || s == 4) {
                    object = (XSParticleDecl)xSParticleDecl.fValue;
                    XSParticleDecl xSParticleDecl2 = (XSParticleDecl)xSParticleDecl.fOtherValue;
                    if (xSParticleDecl2.fType == 1 && ((XSParticleDecl)object).fType == 1) {
                        return new XSSimpleCM(s, (XSElementDecl)((XSParticleDecl)object).fValue, (XSElementDecl)xSParticleDecl2.fValue);
                    }
                } else {
                    if (s == 5) {
                        XSParticleDecl xSParticleDecl3 = (XSParticleDecl)xSParticleDecl.fValue;
                        XSParticleDecl xSParticleDecl4 = (XSParticleDecl)xSParticleDecl.fOtherValue;
                        XSAllCM xSAllCM = new XSAllCM(false);
                        this.gatherAllLeaves(xSParticleDecl3, xSAllCM);
                        this.gatherAllLeaves(xSParticleDecl4, xSAllCM);
                        return xSAllCM;
                    }
                    if (s == 6 || s == 7 || s == 8) {
                        object = (XSParticleDecl)xSParticleDecl.fValue;
                        if (((XSParticleDecl)object).fType == 1) {
                            return new XSSimpleCM(s, (XSElementDecl)((XSParticleDecl)object).fValue);
                        }
                        if (((XSParticleDecl)object).fType == 5) {
                            XSAllCM xSAllCM = new XSAllCM(true);
                            this.gatherAllLeaves((XSParticleDecl)object, xSAllCM);
                            return xSAllCM;
                        }
                    } else {
                        throw new RuntimeException("ImplementationMessages.VAL_CST");
                    }
                }
            }
        }
        this.fLeafCount = 0;
        object = this.buildSyntaxTree(xSParticleDecl);
        return new XSDFACM((CMNode)object, this.fLeafCount, bl);
    }

    private XSParticleDecl expandContentModel(XSParticleDecl xSParticleDecl, int n, int n2) {
        XSParticleDecl xSParticleDecl2 = xSParticleDecl;
        XSParticleDecl xSParticleDecl3 = null;
        if (n == 1 && n2 == 1) {
            return xSParticleDecl;
        }
        if (n == 0 && n2 == 1) {
            return this.createParticle((short)6, xSParticleDecl, null);
        }
        if (n == 0 && n2 == -1) {
            return this.createParticle((short)7, xSParticleDecl, null);
        }
        if (n == 1 && n2 == -1) {
            return this.createParticle((short)8, xSParticleDecl, null);
        }
        if (n2 == -1) {
            if (n < 2) {
                // empty if block
            }
            xSParticleDecl = this.createParticle((short)8, xSParticleDecl, null);
            int n3 = 0;
            while (n3 < n - 1) {
                xSParticleDecl = this.createParticle((short)4, xSParticleDecl2, xSParticleDecl);
                ++n3;
            }
            return xSParticleDecl;
        }
        if (n == 0) {
            xSParticleDecl = xSParticleDecl3 = this.createParticle((short)6, xSParticleDecl2, null);
            int n4 = 0;
            while (n4 < n2 - n - 1) {
                xSParticleDecl = this.createParticle((short)4, xSParticleDecl, xSParticleDecl3);
                ++n4;
            }
        } else {
            int n5 = 0;
            while (n5 < n - 1) {
                xSParticleDecl = this.createParticle((short)4, xSParticleDecl, xSParticleDecl2);
                ++n5;
            }
            xSParticleDecl3 = this.createParticle((short)6, xSParticleDecl2, null);
            int n6 = 0;
            while (n6 < n2 - n) {
                xSParticleDecl = this.createParticle((short)4, xSParticleDecl, xSParticleDecl3);
                ++n6;
            }
        }
        return xSParticleDecl;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void gatherAllLeaves(XSParticleDecl xSParticleDecl, XSAllCM xSAllCM) {
        Object object = xSParticleDecl.fValue;
        Object object2 = xSParticleDecl.fOtherValue;
        short s = xSParticleDecl.fType;
        if (s == 5) {
            this.gatherAllLeaves((XSParticleDecl)object, xSAllCM);
            this.gatherAllLeaves((XSParticleDecl)xSParticleDecl.fOtherValue, xSAllCM);
            return;
        } else if (s == 1) {
            xSAllCM.addElement((XSElementDecl)object, false);
            return;
        } else {
            if (s != 6) throw new RuntimeException("ImplementationMessages.VAL_CSTA");
            if (((XSParticleDecl)object).fType != 1) throw new RuntimeException("ImplementationMessages.VAL_CST");
            xSAllCM.addElement((XSElementDecl)((XSParticleDecl)object).fValue, true);
        }
    }

    private XSParticleDecl createParticle(short s, XSParticleDecl xSParticleDecl, XSParticleDecl xSParticleDecl2) {
        XSParticleDecl xSParticleDecl3 = new XSParticleDecl();
        xSParticleDecl3.fType = s;
        xSParticleDecl3.fValue = xSParticleDecl;
        xSParticleDecl3.fOtherValue = xSParticleDecl2;
        return xSParticleDecl3;
    }

    private final CMNode buildSyntaxTree(XSParticleDecl xSParticleDecl) {
        CMNode cMNode = null;
        if (xSParticleDecl.fType == 2) {
            cMNode = new XSCMLeaf(xSParticleDecl, this.fLeafCount++);
        } else if (xSParticleDecl.fType == 1) {
            cMNode = new XSCMLeaf(xSParticleDecl, this.fLeafCount++);
        } else {
            XSParticleDecl xSParticleDecl2 = (XSParticleDecl)xSParticleDecl.fValue;
            XSParticleDecl xSParticleDecl3 = (XSParticleDecl)xSParticleDecl.fOtherValue;
            if (xSParticleDecl.fType == 3 || xSParticleDecl.fType == 4) {
                cMNode = new XSCMBinOp(xSParticleDecl.fType, this.buildSyntaxTree(xSParticleDecl2), this.buildSyntaxTree(xSParticleDecl3));
            } else if (xSParticleDecl.fType == 7 || xSParticleDecl.fType == 6 || xSParticleDecl.fType == 8) {
                cMNode = new XSCMUniOp(xSParticleDecl.fType, this.buildSyntaxTree(xSParticleDecl2));
            } else {
                throw new RuntimeException("ImplementationMessages.VAL_CST");
            }
        }
        return cMNode;
    }
}

