/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.usage.transmogrify;

import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.ExternalClass;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.ExternalDefinition;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.ExternalSignature;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.IClass;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.IMethod;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.ISignature;
import java.lang.reflect.Constructor;

public class ExternalConstructor
extends ExternalDefinition
implements IMethod {
    private Constructor _javaConstructor;
    private ISignature _signature;

    public ExternalConstructor(Constructor javaConstructor) {
        this._javaConstructor = javaConstructor;
        this._signature = new ExternalSignature(this._javaConstructor.getParameterTypes());
    }

    public String getName() {
        return this._javaConstructor.getDeclaringClass().getName();
    }

    public IClass getType() {
        return new ExternalClass(this._javaConstructor.getDeclaringClass());
    }

    public ISignature getSignature() {
        return this._signature;
    }

    public boolean hasSameSignature(ISignature signature) {
        return this.getSignature().isSame(signature);
    }

    public boolean hasCompatibleSignature(ISignature signature) {
        return signature.isCompatibleWith(this.getSignature());
    }

    public String getQualifiedName() {
        return this.getName() + this.getSignature();
    }

    public Constructor getJavaConstructor() {
        return this._javaConstructor;
    }

    public IClass[] getExceptions() {
        Class<?>[] javaExceptions = this.getJavaConstructor().getExceptionTypes();
        IClass[] result = new IClass[javaExceptions.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = new ExternalClass(javaExceptions[i]);
        }
        return result;
    }

    public String toString() {
        return this.getQualifiedName();
    }

    public boolean equals(Object o) {
        boolean result = false;
        if (o instanceof ExternalConstructor) {
            ExternalConstructor constructor = (ExternalConstructor)o;
            result = this.getJavaConstructor().equals(constructor.getJavaConstructor());
        }
        return result;
    }

    public int hashCode() {
        return this.getJavaConstructor().hashCode();
    }
}

