/*
 * Decompiled with CFR 0.152.
 */
package com.puppycrawl.tools.checkstyle.checks.usage.transmogrify;

import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.ClassDef;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.ExternalConstructor;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.ExternalDefinition;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.ExternalMethod;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.ExternalVariable;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.IClass;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.IMethod;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.ISignature;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.IVariable;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.InterfaceConstructor;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.MethodSpecificityComparator;
import com.puppycrawl.tools.checkstyle.checks.usage.transmogrify.PrimitiveClasses;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;

public class ExternalClass
extends ExternalDefinition
implements IClass {
    private Class _javaClass;
    private List _subclasses;
    private List _implementors;
    private Set _methods;
    static /* synthetic */ Class class$java$lang$Object;

    public ExternalClass(Class javaClass) {
        this._javaClass = javaClass;
        this._subclasses = new ArrayList();
        this._implementors = new ArrayList();
    }

    public Class getJavaClass() {
        return this._javaClass;
    }

    public String getName() {
        return this.getLocalName();
    }

    private String getLocalName() {
        String fullName = this._javaClass.getName();
        return fullName.substring(fullName.lastIndexOf(".") + 1);
    }

    public IClass getSuperclass() {
        ExternalClass result = null;
        Class javaSuperclass = this._javaClass.getSuperclass();
        if (javaSuperclass != null) {
            result = new ExternalClass(javaSuperclass);
        } else if (this._javaClass.isInterface()) {
            result = new ExternalClass(class$java$lang$Object == null ? (class$java$lang$Object = ExternalClass.class$("java.lang.Object")) : class$java$lang$Object);
        }
        return result;
    }

    public IClass[] getInterfaces() {
        Class<?>[] javaInterfaces = this._javaClass.getInterfaces();
        IClass[] result = new IClass[javaInterfaces.length];
        for (int i = 0; i < javaInterfaces.length; ++i) {
            result[i] = new ExternalClass(javaInterfaces[i]);
        }
        return result;
    }

    public IClass getClassDefinition(String name) {
        ExternalClass result = null;
        String qualifiedName = this.getQualifiedName() + "$" + name;
        Class<?>[] classes = this.getJavaClass().getClasses();
        for (int i = 0; i < classes.length; ++i) {
            String candidateQualifiedName = classes[i].getName();
            if (!qualifiedName.equals(candidateQualifiedName)) continue;
            result = new ExternalClass(classes[i]);
            break;
        }
        return result;
    }

    public IVariable getVariableDefinition(String name) {
        IVariable result = null;
        Field javaField = null;
        try {
            javaField = this._javaClass.getDeclaredField(name);
        }
        catch (NoSuchFieldException ignoreMe) {
            // empty catch block
        }
        if (javaField == null) {
            Class<?>[] interfaces = this._javaClass.getInterfaces();
            for (int i = 0; i < interfaces.length && javaField == null; ++i) {
                try {
                    javaField = interfaces[i].getDeclaredField(name);
                    continue;
                }
                catch (NoSuchFieldException ignoreMe) {
                    // empty catch block
                }
            }
        }
        if (javaField != null) {
            result = new ExternalVariable(javaField);
        } else if (this.getSuperclass() != null) {
            result = this.getSuperclass().getVariableDefinition(name);
        }
        return result;
    }

    public IMethod getMethodDefinition(String name, ISignature signature) {
        IMethod result = null;
        if (name.equals(this.getName())) {
            result = this.getConstructorDefinition(signature);
        } else {
            Method[] methods = this._javaClass.getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                ExternalMethod method;
                if (!name.equals(methods[i].getName()) || !(method = new ExternalMethod(methods[i])).hasSameSignature(signature)) continue;
                result = method;
                break;
            }
            if (result == null) {
                result = this.getMostCompatibleMethod(name, signature);
            }
            if (result == null && this.getSuperclass() != null) {
                result = this.getSuperclass().getMethodDefinition(name, signature);
            }
            if (result == null) {
                IClass[] interfaces = this.getInterfaces();
                for (int i = 0; i < interfaces.length && (result = interfaces[i].getMethodDefinition(name, signature)) == null; ++i) {
                }
            }
        }
        return result;
    }

    public IMethod getMostCompatibleMethod(String name, ISignature signature) {
        IMethod result = null;
        TreeSet<IMethod> compatibleMethods = new TreeSet<IMethod>(new MethodSpecificityComparator());
        Iterator it = this.getMethods().iterator();
        while (it.hasNext()) {
            IMethod method = (IMethod)it.next();
            if (!name.equals(method.getName()) || !method.hasCompatibleSignature(signature)) continue;
            compatibleMethods.add(method);
        }
        if (!compatibleMethods.isEmpty()) {
            result = (IMethod)compatibleMethods.first();
        }
        return result;
    }

    private Collection getMethods() {
        if (this._methods == null) {
            this._methods = new HashSet();
            Method[] methods = this._javaClass.getDeclaredMethods();
            for (int i = 0; i < methods.length; ++i) {
                this._methods.add(new ExternalMethod(methods[i]));
            }
        }
        return this._methods;
    }

    public IMethod getConstructorDefinition(ISignature signature) {
        IMethod result = null;
        result = this._javaClass.isInterface() ? this.getInterfaceConstructor(signature) : this.getClassConstructor(signature);
        return result;
    }

    private IMethod getInterfaceConstructor(ISignature signature) {
        InterfaceConstructor result = null;
        if (signature.getParameters().length == 0) {
            result = new InterfaceConstructor(this._javaClass);
        }
        return result;
    }

    private IMethod getClassConstructor(ISignature signature) {
        ExternalConstructor constructor;
        int i;
        ExternalConstructor result = null;
        Constructor<?>[] constructors = this._javaClass.getConstructors();
        for (i = 0; i < constructors.length; ++i) {
            constructor = new ExternalConstructor(constructors[i]);
            if (!constructor.hasSameSignature(signature)) continue;
            result = constructor;
            break;
        }
        if (result == null) {
            for (i = 0; i < constructors.length; ++i) {
                constructor = new ExternalConstructor(constructors[i]);
                if (!constructor.hasCompatibleSignature(signature)) continue;
                result = constructor;
                break;
            }
        }
        return result;
    }

    public boolean isCompatibleWith(IClass type) {
        boolean result = false;
        if (this.isPrimitive() && type.isPrimitive()) {
            result = PrimitiveClasses.typesAreCompatible((ExternalClass)type, this);
        } else if (type.equals(this)) {
            result = true;
        } else if (this.getSuperclass() != null && this.getSuperclass().isCompatibleWith(type)) {
            result = true;
        } else if (this._javaClass.getInterfaces().length > 0) {
            Class<?>[] interfaces = this._javaClass.getInterfaces();
            for (int i = 0; i < interfaces.length; ++i) {
                if (!new ExternalClass(interfaces[i]).isCompatibleWith(type)) continue;
                result = true;
                break;
            }
        }
        return result;
    }

    private boolean isPrimitiveCompatibleWith(IClass type) {
        boolean result = false;
        return result;
    }

    public void addImplementor(ClassDef implementor) {
        this._implementors.add(implementor);
    }

    public List getImplementors() {
        return this._implementors;
    }

    public void addSubclass(ClassDef subclass) {
        this._subclasses.add(subclass);
    }

    public List getSubclasses() {
        return this._subclasses;
    }

    public String getQualifiedName() {
        return this._javaClass.getName();
    }

    public boolean isPrimitive() {
        return this.getJavaClass().isPrimitive();
    }

    public IClass[] getInnerClasses() {
        Class<?>[] innerJavaClasses = this.getJavaClass().getDeclaredClasses();
        IClass[] result = new IClass[innerJavaClasses.length];
        for (int i = 0; i < result.length; ++i) {
            result[i] = new ExternalClass(innerJavaClasses[i]);
        }
        return result;
    }

    public String toString() {
        return this.getClass() + "[" + this.getQualifiedName() + "]";
    }

    public boolean equals(Object o) {
        boolean result = false;
        if (o instanceof ExternalClass) {
            ExternalClass compared = (ExternalClass)o;
            result = this.getJavaClass().equals(compared.getJavaClass());
        }
        return result;
    }

    public int hashCode() {
        return this.getJavaClass().hashCode();
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

